/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition;

import de.gwdg.metadataqa.marc.Extractable;
import de.gwdg.metadataqa.marc.Validatable;
import de.gwdg.metadataqa.marc.dao.record.BibliographicRecord;
import de.gwdg.metadataqa.marc.definition.ControlField;
import de.gwdg.metadataqa.marc.definition.ControlValue;
import de.gwdg.metadataqa.marc.definition.structure.ControlfieldPositionDefinition;
import de.gwdg.metadataqa.marc.model.SolrFieldType;
import de.gwdg.metadataqa.marc.model.validation.ValidationError;
import de.gwdg.metadataqa.marc.utils.keygenerator.PositionalControlFieldKeyGenerator;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class PositionalControlField
extends ControlField
implements Extractable,
Validatable {
    protected BibliographicRecord marcRecord;
    protected Map<ControlfieldPositionDefinition, String> valuesMap;
    protected List<ControlValue> valuesList;
    protected List<ValidationError> validationErrors;

    public void setMarcRecord(BibliographicRecord marcRecord) {
        this.marcRecord = marcRecord;
        for (ControlValue value : this.valuesList) {
            value.setMarcRecord(marcRecord);
        }
    }

    @Override
    public Map<String, List<String>> getKeyValuePairs() {
        return this.getKeyValuePairs(SolrFieldType.MARC);
    }

    public Map<String, List<String>> getKeyValuePairs(String tag, String mqTag, SolrFieldType type2) {
        LinkedHashMap<String, List<String>> map = new LinkedHashMap<String, List<String>>();
        PositionalControlFieldKeyGenerator keyGenerator = new PositionalControlFieldKeyGenerator(tag, mqTag, type2);
        if (this.content != null) {
            map.put(keyGenerator.forTag(), Arrays.asList(this.content));
            for (Map.Entry<ControlfieldPositionDefinition, String> entry : this.valuesMap.entrySet()) {
                ControlfieldPositionDefinition position = entry.getKey();
                String value = position.resolve(entry.getValue());
                map.put(keyGenerator.forSubfield(position), Arrays.asList(value));
            }
        }
        return map;
    }

    public Map<ControlfieldPositionDefinition, String> getMap() {
        return this.valuesMap;
    }
}

