/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.datastore;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.BaseHttpSolrClient;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.MapSolrParams;

public class MarcSolrClient {
    private static final Logger logger = Logger.getLogger(MarcSolrClient.class.getCanonicalName());
    public static final String ID_QUERY = "id:\"%s\"";
    private String defaultUrl = "http://localhost:8983/solr";
    private SolrClient solrClient;
    private String collection;
    private boolean trimId = false;

    public MarcSolrClient() {
        this.initialize(this.defaultUrl);
    }

    public MarcSolrClient(String url) {
        this.initialize(url);
    }

    public MarcSolrClient(String url, String collection) {
        this.initialize(url, collection);
    }

    public MarcSolrClient(SolrClient client) {
        this.solrClient = client;
    }

    private void initialize(String url) {
        this.solrClient = new HttpSolrClient.Builder(url).build();
    }

    private void initialize(String url, String collection) {
        this.solrClient = new HttpSolrClient.Builder(url).build();
        this.collection = collection;
    }

    public void indexMap(String id, Map<String, List<String>> objectMap) {
        this.index(this.createSolrDoc(id, objectMap));
    }

    public void index(SolrInputDocument document) {
        try {
            this.solrClient.add(document);
        }
        catch (IOException | SolrServerException | BaseHttpSolrClient.RemoteSolrException ex) {
            logger.log(Level.WARNING, "document", document);
            logger.log(Level.WARNING, "Commit exception", ex);
            throw new RuntimeException(ex);
        }
    }

    public SolrInputDocument createSolrDoc(String id, Map<String, List<String>> objectMap) {
        SolrInputDocument document = new SolrInputDocument();
        document.addField("id", this.trimId ? id.trim() : id);
        for (Map.Entry<String, List<String>> entry : objectMap.entrySet()) {
            Object key = entry.getKey();
            List<String> value = entry.getValue();
            if (value == null) continue;
            if (!((String)key).endsWith("_sni") && !((String)key).endsWith("_ss")) {
                key = (String)key + "_ss";
            }
            document.addField((String)key, value);
        }
        return document;
    }

    public void indexDuplumKey(String id, Map<String, Object> objectMap) throws IOException, SolrServerException {
        SolrInputDocument document = new SolrInputDocument();
        document.addField("id", id);
        for (Map.Entry<String, Object> entry : objectMap.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (value == null) continue;
            if (!((String)key).endsWith("_sni") && !((String)key).endsWith("_ss")) {
                key = (String)key + "_ss";
            }
            document.addField((String)key, value);
        }
        try {
            this.solrClient.add(document);
        }
        catch (BaseHttpSolrClient.RemoteSolrException ex) {
            logger.log(Level.WARNING, "document", document);
            logger.log(Level.WARNING, "Commit exception", ex);
        }
    }

    public void commit() {
        try {
            this.solrClient.commit();
        }
        catch (IOException | SolrServerException e) {
            logger.log(Level.WARNING, "commit", e);
        }
    }

    public void optimize() {
        try {
            this.solrClient.optimize();
        }
        catch (IOException | SolrServerException e) {
            logger.log(Level.WARNING, "optimize", e);
        }
    }

    public SolrDocument get(String id) {
        try {
            QueryResponse response = this.solrClient.query(new MapSolrParams(Map.of("q", String.format(ID_QUERY, id))));
            SolrDocumentList documents = response.getResults();
            if (documents.getNumFound() > 0L) {
                SolrDocument doc = (SolrDocument)documents.get(0);
                doc.removeFields("id");
                doc.removeFields("_version_");
                return doc;
            }
        }
        catch (SolrServerException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public boolean getTrimId() {
        return this.trimId;
    }

    public void setTrimId(boolean trimId) {
        this.trimId = trimId;
    }
}

