/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.dao.record;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.gwdg.metadataqa.marc.Extractable;
import de.gwdg.metadataqa.marc.MarcFactory;
import de.gwdg.metadataqa.marc.MarcSubfield;
import de.gwdg.metadataqa.marc.analysis.AuthorityCategory;
import de.gwdg.metadataqa.marc.analysis.ShelfReadyFieldsBooks;
import de.gwdg.metadataqa.marc.analysis.ThompsonTraillFields;
import de.gwdg.metadataqa.marc.cli.utils.IgnorableFields;
import de.gwdg.metadataqa.marc.dao.Control001;
import de.gwdg.metadataqa.marc.dao.Control003;
import de.gwdg.metadataqa.marc.dao.Control005;
import de.gwdg.metadataqa.marc.dao.Control006;
import de.gwdg.metadataqa.marc.dao.Control007;
import de.gwdg.metadataqa.marc.dao.Control008;
import de.gwdg.metadataqa.marc.dao.DataField;
import de.gwdg.metadataqa.marc.dao.Leader;
import de.gwdg.metadataqa.marc.dao.MarcControlField;
import de.gwdg.metadataqa.marc.dao.MarcPositionalControlField;
import de.gwdg.metadataqa.marc.definition.MarcVersion;
import de.gwdg.metadataqa.marc.definition.bibliographic.SchemaType;
import de.gwdg.metadataqa.marc.definition.structure.ControlfieldPositionDefinition;
import de.gwdg.metadataqa.marc.definition.structure.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.Indicator;
import de.gwdg.metadataqa.marc.model.SolrFieldType;
import de.gwdg.metadataqa.marc.utils.marcspec.legacy.MarcSpec;
import de.gwdg.metadataqa.marc.utils.pica.path.PicaPath;
import de.gwdg.metadataqa.marc.utils.unimarc.UnimarcConverter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public abstract class BibliographicRecord
implements Extractable,
Serializable {
    private static final Logger logger = Logger.getLogger(BibliographicRecord.class.getCanonicalName());
    private static final Pattern dataFieldPattern = Pattern.compile("^(\\d\\d\\d)\\$(.*)$");
    private static final Pattern positionalPattern = Pattern.compile("^(Leader|00[678])/(.*)$");
    private static final List<String> simpleControlTags = Arrays.asList("001", "003", "005");
    private static final List<String> MARC21_SUBJECT_TAGS = Arrays.asList("052", "055", "072", "080", "082", "083", "084", "085", "086", "600", "610", "611", "630", "647", "648", "650", "651", "653", "654", "655", "656", "657", "658", "662");
    protected static final List<String> PICA_SUBJECT_TAGS = Arrays.asList("045A", "045B", "045F", "045R");
    private static final Map<String, Boolean> undefinedTags = new HashMap<String, Boolean>();
    private Leader leader;
    private MarcControlField control001;
    private MarcControlField control003;
    private MarcControlField control005;
    private List<Control006> control006 = new ArrayList<Control006>();
    private List<Control007> control007 = new ArrayList<Control007>();
    private Control008 control008;
    private List<DataField> datafields;
    private Map<String, List<DataField>> datafieldIndex;
    private Map<String, List<MarcControlField>> controlfieldIndex;
    Map<String, List<String>> mainKeyValuePairs;
    protected SchemaType schemaType = SchemaType.MARC21;
    private List<String> unhandledTags;

    public BibliographicRecord() {
        this.datafields = new ArrayList<DataField>();
        this.datafieldIndex = new TreeMap<String, List<DataField>>();
        this.controlfieldIndex = new TreeMap<String, List<MarcControlField>>();
        this.unhandledTags = new ArrayList<String>();
    }

    public BibliographicRecord(String id) {
        this();
        this.control001 = new Control001(id);
    }

    public void addDataField(DataField dataField) {
        dataField.setMarcRecord(this);
        this.indexField(dataField);
        this.datafields.add(dataField);
    }

    private void indexField(DataField dataField) {
        String tag = dataField.getTag();
        if (tag == null) {
            logger.warning("null tag in indexField() " + dataField);
        }
        this.datafieldIndex.computeIfAbsent(tag, s -> new ArrayList());
        this.datafieldIndex.get(tag).add(dataField);
    }

    public void addUnhandledTags(String tag) {
        this.unhandledTags.add(tag);
    }

    public void setLeader(Leader leader) {
        this.leader = leader;
        leader.setMarcRecord(this);
    }

    public void setLeader(String leader) {
        this.leader = new Leader(leader);
        this.leader.setMarcRecord(this);
    }

    public void setLeader(String leader, MarcVersion marcVersion) {
        if (marcVersion.equals((Object)MarcVersion.UNIMARC)) {
            leader = UnimarcConverter.leaderFromUnimarc(leader);
        }
        this.leader = new Leader(leader);
        this.leader.setMarcRecord(this);
    }

    public Leader getLeader() {
        return this.leader;
    }

    public Leader.Type getType() {
        return this.leader.getType();
    }

    public MarcControlField getControl001() {
        return this.control001;
    }

    public BibliographicRecord setControl001(MarcControlField control001) {
        this.control001 = control001;
        control001.setMarcRecord(this);
        this.controlfieldIndex.put(control001.getDefinition().getTag(), Arrays.asList(control001));
        return this;
    }

    public MarcControlField getControl003() {
        return this.control003;
    }

    public void setControl003(MarcControlField control003) {
        this.control003 = control003;
        control003.setMarcRecord(this);
        this.controlfieldIndex.put(control003.getDefinition().getTag(), Arrays.asList(control003));
    }

    public MarcControlField getControl005() {
        return this.control005;
    }

    public void setControl005(MarcControlField control005) {
        this.control005 = control005;
        control005.setMarcRecord(this);
        this.controlfieldIndex.put(control005.getDefinition().getTag(), Arrays.asList(control005));
    }

    public List<Control006> getControl006() {
        return this.control006;
    }

    public void setControl006(Control006 control006) {
        this.control006.add(control006);
        control006.setMarcRecord(this);
        this.controlfieldIndex.put(control006.getDefinition().getTag(), this.control006);
    }

    public List<Control007> getControl007() {
        return this.control007;
    }

    public void setControl007(Control007 control007) {
        this.control007.add(control007);
        control007.setMarcRecord(this);
        this.controlfieldIndex.put(control007.getDefinition().getTag(), this.control007);
    }

    public Control008 getControl008() {
        return this.control008;
    }

    public void setControl008(Control008 control008) {
        this.control008 = control008;
        control008.setMarcRecord(this);
        this.controlfieldIndex.put(control008.getDefinition().getTag(), Arrays.asList(control008));
    }

    public String getId() {
        return this.control001.getContent();
    }

    public String getId(boolean trim) {
        String id = this.getId();
        if (trim) {
            id = id.trim();
        }
        return id;
    }

    public List<MarcControlField> getControlfields() {
        ArrayList<MarcControlField> list = new ArrayList<MarcControlField>();
        list.add(this.control001);
        if (this.control003 != null) {
            list.add(this.control003);
        }
        if (this.control005 != null) {
            list.add(this.control005);
        }
        if (this.control006 != null && !this.control006.isEmpty()) {
            list.addAll(this.control006);
        }
        if (this.control007 != null && !this.control007.isEmpty()) {
            list.addAll(this.control007);
        }
        if (this.control008 != null) {
            list.add(this.control008);
        }
        return list;
    }

    public List<MarcControlField> getSimpleControlfields() {
        return Arrays.asList(this.control001, this.control003, this.control005);
    }

    public List<MarcPositionalControlField> getPositionalControlfields() {
        ArrayList<MarcPositionalControlField> list = new ArrayList<MarcPositionalControlField>();
        if (this.control006 != null && !this.control006.isEmpty()) {
            list.addAll(this.control006);
        }
        if (this.control007 != null && !this.control007.isEmpty()) {
            list.addAll(this.control007);
        }
        if (this.control008 != null) {
            list.add(this.control008);
        }
        return list;
    }

    public boolean hasDatafield(String tag) {
        return this.datafieldIndex.containsKey(tag);
    }

    public List<DataField> getDatafield(String tag) {
        return this.datafieldIndex.getOrDefault(tag, null);
    }

    public List<DataField> getDatafields() {
        return this.datafields;
    }

    public boolean exists(String tag) {
        List<DataField> fields2 = this.getDatafield(tag);
        return fields2 != null && !fields2.isEmpty();
    }

    public List<String> extract(String tag, String subfield) {
        return this.extract(tag, subfield, RESOLVE.NONE);
    }

    public List<String> extract(String tag, String subfield, RESOLVE doResolve) {
        ArrayList<String> values2 = new ArrayList<String>();
        List<DataField> fields2 = this.getDatafield(tag);
        if (fields2 != null && !fields2.isEmpty()) {
            for (DataField field : fields2) {
                if (subfield.equals("ind1") || subfield.equals("ind2")) {
                    Indicator indicator;
                    String value;
                    if (subfield.equals("ind1")) {
                        value = field.getInd1();
                        indicator = field.getDefinition().getInd1();
                    } else {
                        value = field.getInd2();
                        indicator = field.getDefinition().getInd2();
                    }
                    if (indicator.getCode(value) == null) {
                        values2.add(value);
                        continue;
                    }
                    values2.add(indicator.getCode(value).getLabel());
                    continue;
                }
                List<MarcSubfield> subfieldInstances = field.getSubfield(subfield);
                if (subfieldInstances == null) continue;
                for (MarcSubfield subfieldInstance : subfieldInstances) {
                    Object value = null;
                    switch (doResolve) {
                        case RESOLVE: {
                            value = subfieldInstance.resolve();
                            break;
                        }
                        case NONE: {
                            value = subfieldInstance.getValue();
                            break;
                        }
                        case BOTH: {
                            value = subfieldInstance.resolve() + "##" + subfieldInstance.getValue();
                        }
                    }
                    values2.add((String)value);
                }
            }
        }
        return values2;
    }

    public List<String> getUnhandledTags() {
        return this.unhandledTags;
    }

    public String format() {
        StringBuffer output = new StringBuffer();
        for (DataField field : this.datafields) {
            output.append(field.format());
        }
        return output.toString();
    }

    public String formatAsText() {
        StringBuffer output = new StringBuffer();
        for (DataField field : this.datafields) {
            output.append(field.formatAsText());
        }
        return output.toString();
    }

    public String formatAsMarc() {
        StringBuffer output = new StringBuffer();
        for (DataField field : this.datafields) {
            output.append(field.formatAsMarc());
        }
        return output.toString();
    }

    public String formatForIndex() {
        StringBuffer output = new StringBuffer();
        for (DataField field : this.datafields) {
            output.append(field.formatForIndex());
        }
        return output.toString();
    }

    @Override
    public Map<String, List<String>> getKeyValuePairs() {
        return this.getKeyValuePairs(SolrFieldType.MARC);
    }

    @Override
    public Map<String, List<String>> getKeyValuePairs(SolrFieldType type2) {
        return this.getKeyValuePairs(type2, false, MarcVersion.MARC21);
    }

    @Override
    public Map<String, List<String>> getKeyValuePairs(SolrFieldType type2, MarcVersion marcVersion) {
        return this.getKeyValuePairs(type2, false, marcVersion);
    }

    public Map<String, List<String>> getKeyValuePairs(SolrFieldType type2, boolean withDeduplication, MarcVersion marcVersion) {
        if (this.mainKeyValuePairs == null) {
            this.mainKeyValuePairs = new LinkedHashMap<String, List<String>>();
            if (!this.schemaType.equals((Object)SchemaType.PICA)) {
                this.mainKeyValuePairs.put("type", Arrays.asList(this.getType().getValue()));
                this.mainKeyValuePairs.putAll(this.leader.getKeyValuePairs(type2));
            }
            for (MarcControlField controlField : this.getControlfields()) {
                if (controlField == null) continue;
                this.mainKeyValuePairs.putAll(controlField.getKeyValuePairs(type2));
            }
            for (DataField field : this.datafields) {
                Map<String, List<String>> keyValuePairs = field.getKeyValuePairs(type2, marcVersion);
                for (Map.Entry<String, List<String>> entry : keyValuePairs.entrySet()) {
                    String key = entry.getKey();
                    List<String> values2 = entry.getValue();
                    if (this.mainKeyValuePairs.containsKey(key)) {
                        this.mainKeyValuePairs.put(key, this.mergeValues(new ArrayList<String>((Collection)this.mainKeyValuePairs.get(key)), values2, withDeduplication));
                        continue;
                    }
                    this.mainKeyValuePairs.put(key, values2);
                }
            }
        }
        return this.mainKeyValuePairs;
    }

    private List<String> mergeValues(List<String> existingValues, List<String> values2, boolean withDeduplication) {
        if (withDeduplication) {
            for (String value : values2) {
                if (existingValues.contains(value)) continue;
                existingValues.add(value);
            }
        } else {
            existingValues.addAll(values2);
        }
        return existingValues;
    }

    public String asJson() {
        ObjectMapper mapper = new ObjectMapper();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        if (!this.schemaType.equals((Object)SchemaType.PICA)) {
            map.put("leader", this.leader.getContent());
        }
        for (MarcControlField marcControlField : this.getControlfields()) {
            if (marcControlField == null) continue;
            map.put(marcControlField.getDefinition().getTag(), marcControlField.getContent());
        }
        for (DataField dataField : this.datafields) {
            if (dataField == null) continue;
            LinkedHashMap<String, Object> fieldMap = new LinkedHashMap<String, Object>();
            fieldMap.put("ind1", dataField.getInd1());
            fieldMap.put("ind2", dataField.getInd2());
            LinkedHashMap<String, String> subfields = new LinkedHashMap<String, String>();
            for (MarcSubfield subfield : dataField.getSubfields()) {
                subfields.put(subfield.getCode(), subfield.getValue());
            }
            fieldMap.put("subfields", subfields);
            Object tag = dataField.getOccurrence() != null ? dataField.getTag() + "/" + dataField.getOccurrence() : (dataField.getDefinition() != null ? dataField.getDefinition().getTag() : dataField.getTag());
            map.computeIfAbsent((String)tag, s -> new ArrayList());
            ((ArrayList)map.get(tag)).add(fieldMap);
        }
        String json = null;
        try {
            json = mapper.writeValueAsString(map);
        }
        catch (JsonProcessingException jsonProcessingException) {
            logger.log(Level.WARNING, "error in asJson()", jsonProcessingException);
        }
        return json;
    }

    public boolean isIgnorableField(String tag, IgnorableFields ignorableFields) {
        if (ignorableFields == null) {
            return false;
        }
        return ignorableFields.contains(tag);
    }

    public List<String> search(String path, String query) {
        ArrayList<String> results = new ArrayList<String>();
        if (path.equals("001") || path.equals("003") || path.equals("005")) {
            this.searchControlField(path, query, results);
        } else if (path.startsWith("006")) {
            for (Control006 instance : this.control006) {
                this.searchPositionalControlField(instance, path, query, results);
            }
        } else if (path.startsWith("007")) {
            for (Control007 instance : this.control007) {
                this.searchPositionalControlField(instance, path, query, results);
            }
        } else if (path.startsWith("008")) {
            this.searchPositionalControlField(this.control008, path, query, results);
        } else {
            Matcher matcher = dataFieldPattern.matcher(path);
            if (matcher.matches()) {
                String tag = matcher.group(1);
                String subfieldCode = matcher.group(2);
                if (this.datafieldIndex.containsKey(tag)) {
                    for (DataField field : this.datafieldIndex.get(tag)) {
                        if (this.searchDatafield(query, results, subfieldCode, field)) break;
                    }
                }
            }
            if ((matcher = positionalPattern.matcher(path)).matches()) {
                this.searchByPosition(query, results, matcher);
            }
        }
        return results;
    }

    public List<String> select(MarcSpec selector) {
        ArrayList<String> results = new ArrayList<String>();
        if (selector.getFieldTag().equals("LDR")) {
            if (selector.hasRangeSelector()) {
                results.add(selector.selectRange(this.leader.getContent()));
            } else {
                results.add(this.leader.getContent());
            }
        } else if (this.controlfieldIndex.containsKey(selector.getFieldTag())) {
            for (MarcControlField field : this.controlfieldIndex.get(selector.getFieldTag())) {
                if (field == null) continue;
                if (!simpleControlTags.contains(field.getDefinition().getTag())) {
                    // empty if block
                }
                if (selector.hasRangeSelector()) {
                    results.add(selector.selectRange(field.getContent()));
                    continue;
                }
                results.add(field.getContent());
            }
        } else if (this.datafieldIndex.containsKey(selector.getFieldTag())) {
            for (DataField field : this.datafieldIndex.get(selector.getFieldTag())) {
                if (field == null) continue;
                List<String> codes = selector.getSubfieldsAsList();
                if (codes.isEmpty()) {
                    results.add(BibliographicRecord.joinAllSubfields(field));
                    continue;
                }
                for (String subfieldCode : codes) {
                    List<MarcSubfield> subfields = field.getSubfield(subfieldCode);
                    if (subfields == null) continue;
                    for (MarcSubfield subfield : subfields) {
                        results.add(subfield.getValue());
                    }
                }
            }
        } else if (selector.getFieldTag().equals("008") && this.control008 != null) {
            if (selector.getCharStart() != null) {
                ControlfieldPositionDefinition definition = this.control008.getSubfieldByPosition(selector.getCharStart());
                results.add(this.control008.getMap().get(definition));
            } else {
                results.add(this.control008.getContent());
            }
        }
        return results;
    }

    private static String joinAllSubfields(DataField field) {
        ArrayList<String> values2 = new ArrayList<String>();
        for (MarcSubfield subfield : field.getSubfields()) {
            values2.add(subfield.getValue());
        }
        return StringUtils.join(values2, " ");
    }

    public List<String> select(PicaPath selector) {
        if (!this.schemaType.equals((Object)SchemaType.PICA)) {
            throw new IllegalArgumentException("The record is not a PICA record");
        }
        ArrayList<String> results = new ArrayList<String>();
        List<DataField> dataFields = this.getDatafield(selector.getTag());
        if (dataFields != null) {
            for (DataField dataField : dataFields) {
                for (String code : selector.getSubfields().getCodes()) {
                    List<MarcSubfield> dubfields = dataField.getSubfield(code);
                    if (dubfields == null) continue;
                    for (MarcSubfield subfield : dubfields) {
                        results.add(subfield.getValue());
                    }
                }
            }
        }
        return results;
    }

    private void searchByPosition(String query, List<String> results, Matcher matcher) {
        int end;
        int start;
        String tag = matcher.group(1);
        String position = matcher.group(2);
        if (position.contains("-")) {
            String[] parts = position.split("-", 2);
            start = Integer.parseInt(parts[0]);
            end = Integer.parseInt(parts[1]);
        } else {
            start = Integer.parseInt(position);
            end = start + 1;
        }
        String content = null;
        if (tag.equals("Leader")) {
            content = this.leader.getLeaderString();
        } else {
            MarcControlField controlField = null;
            switch (tag) {
                case "006": {
                    controlField = this.control006.get(0);
                    break;
                }
                case "007": {
                    controlField = this.control007.get(0);
                    break;
                }
                case "008": {
                    controlField = this.control008;
                    break;
                }
            }
            if (controlField != null) {
                content = controlField.getContent();
            }
        }
        if (content != null && content.substring(start, end).equals(query)) {
            results.add(content.substring(start, end));
        }
    }

    private boolean searchDatafield(String query, List<String> results, String subfieldCode, DataField field) {
        if (subfieldCode.equals("ind1") && field.getInd1().equals(query)) {
            results.add(field.getInd1());
            return true;
        }
        if (subfieldCode.equals("ind2") && field.getInd2().equals(query)) {
            results.add(field.getInd2());
            return true;
        }
        List<MarcSubfield> subfields = field.getSubfield(subfieldCode);
        if (subfields != null) {
            for (MarcSubfield subfield : subfields) {
                if (!subfield.getValue().equals(query)) continue;
                results.add(subfield.getValue());
                return true;
            }
        }
        return false;
    }

    private void searchControlField(String path, String query, List<String> results) {
        MarcControlField controlField = null;
        switch (path) {
            case "001": {
                controlField = this.control001;
                break;
            }
            case "003": {
                controlField = this.control003;
                break;
            }
            case "005": {
                controlField = this.control005;
                break;
            }
        }
        if (controlField != null && controlField.getContent().equals(query)) {
            results.add(controlField.getContent());
        }
    }

    private void searchPositionalControlField(MarcPositionalControlField controlField, String path, String query, List<String> results) {
        if (controlField != null) {
            Map<ControlfieldPositionDefinition, String> map = controlField.getMap();
            for (ControlfieldPositionDefinition subfield : controlField.getMap().keySet()) {
                if (!subfield.getId().equals(path)) continue;
                if (!map.get(subfield).equals(query)) break;
                results.add(map.get(subfield));
                break;
            }
        }
    }

    public List<DataField> getAuthorityFields(List<String> tags) {
        ArrayList<DataField> subjects = new ArrayList<DataField>();
        for (String tag : tags) {
            List<DataField> fields2 = this.getDatafield(tag);
            if (fields2 == null || fields2.isEmpty()) continue;
            subjects.addAll(fields2);
        }
        return subjects;
    }

    public Map<DataField, AuthorityCategory> getAuthorityFields(Map<AuthorityCategory, List<String>> tags) {
        LinkedHashMap<DataField, AuthorityCategory> subjects = new LinkedHashMap<DataField, AuthorityCategory>();
        for (Map.Entry<AuthorityCategory, List<String>> entry : tags.entrySet()) {
            AuthorityCategory category = entry.getKey();
            for (String tag : entry.getValue()) {
                List<DataField> fields2 = this.getDatafield(tag);
                if (fields2 == null || fields2.isEmpty()) continue;
                for (DataField field : fields2) {
                    subjects.put(field, category);
                }
            }
        }
        return subjects;
    }

    public abstract List<DataField> getAuthorityFields();

    public abstract Map<DataField, AuthorityCategory> getAuthorityFieldsMap();

    public abstract boolean isAuthorityTag(String var1);

    public abstract boolean isSkippableAuthoritySubfield(String var1, String var2);

    public abstract boolean isSubjectTag(String var1);

    public abstract boolean isSkippableSubjectSubfield(String var1, String var2);

    public abstract Map<ShelfReadyFieldsBooks, Map<String, List<String>>> getShelfReadyMap();

    public abstract Map<ThompsonTraillFields, List<String>> getThompsonTraillTagsMap();

    public List<DataField> getSubjects() {
        List<String> tags;
        ArrayList<DataField> subjects = new ArrayList<DataField>();
        switch (this.schemaType) {
            case PICA: {
                tags = PICA_SUBJECT_TAGS;
                break;
            }
            default: {
                tags = MARC21_SUBJECT_TAGS;
            }
        }
        for (String tag : tags) {
            List<DataField> fields2 = this.getDatafield(tag);
            if (fields2 == null || fields2.isEmpty()) continue;
            subjects.addAll(fields2);
        }
        return subjects;
    }

    public List<DataField> getSubject6xx() {
        ArrayList<DataField> subjects = new ArrayList<DataField>();
        List<String> tags = Arrays.asList("600", "610", "611", "630", "648", "650", "651");
        for (String tag : tags) {
            List<DataField> fields2 = this.getDatafield(tag);
            if (fields2 == null || fields2.isEmpty()) continue;
            subjects.addAll(fields2);
        }
        return subjects;
    }

    public void setField(String tag, String content) {
        this.setField(tag, content, MarcVersion.MARC21);
    }

    public void setField(String tag, String content, MarcVersion marcVersion) {
        if (marcVersion.equals((Object)MarcVersion.UNIMARC)) {
            content = UnimarcConverter.contentFromUnimarc(tag, content);
            tag = UnimarcConverter.tagFromUnimarc(tag);
        }
        if (tag.equals("001")) {
            this.setControl001(new Control001(content));
        } else if (tag.equals("003")) {
            this.setControl003(new Control003(content));
        } else if (tag.equals("005")) {
            this.setControl005(new Control005(content, this));
        } else if (tag.equals("006")) {
            this.setControl006(new Control006(content, this));
        } else if (tag.equals("007")) {
            this.setControl007(new Control007(content, this));
        } else if (tag.equals("008")) {
            this.setControl008(new Control008(content, this));
        } else {
            DataFieldDefinition definition = MarcFactory.getDataFieldDefinition(tag, marcVersion);
            if (definition == null) {
                this.addUnhandledTags(tag);
            }
            DataField dataField = new DataField(tag, content, marcVersion);
            this.addDataField(dataField);
        }
    }

    public void setField(String tag, String ind1, String ind2, String content, MarcVersion marcVersion) {
        if (tag.equals("001")) {
            this.setControl001(new Control001(content));
        } else if (tag.equals("003")) {
            this.setControl003(new Control003(content));
        } else if (tag.equals("005")) {
            this.setControl005(new Control005(content, this));
        } else if (tag.equals("006")) {
            this.setControl006(new Control006(content, this));
        } else if (tag.equals("007")) {
            this.setControl007(new Control007(content, this));
        } else if (tag.equals("008")) {
            this.setControl008(new Control008(content, this));
        } else {
            DataFieldDefinition definition = MarcFactory.getDataFieldDefinition(tag, marcVersion);
            if (definition == null) {
                this.addUnhandledTags(tag);
            }
            this.addDataField(new DataField(tag, ind1, ind2, content, marcVersion));
        }
    }

    public SchemaType getSchemaType() {
        return this.schemaType;
    }

    public void setSchemaType(SchemaType schemaType) {
        this.schemaType = schemaType;
    }

    public static enum RESOLVE {
        NONE,
        RESOLVE,
        BOTH;

    }
}

