/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.cli.utils.ignorablerecords;

import de.gwdg.metadataqa.marc.Utils;
import de.gwdg.metadataqa.marc.cli.utils.ignorablerecords.RecordFilter;
import de.gwdg.metadataqa.marc.cli.utils.ignorablerecords.RecordFilterMarc21;
import de.gwdg.metadataqa.marc.cli.utils.ignorablerecords.RecordFilterPica;
import de.gwdg.metadataqa.marc.definition.bibliographic.SchemaType;

public class RecordFilterFactory {
    private RecordFilterFactory() {
    }

    public static RecordFilter create(SchemaType type2, String allowableRecordsInput) {
        if (allowableRecordsInput.startsWith("base64:")) {
            allowableRecordsInput = Utils.base64decode(allowableRecordsInput);
        }
        if (type2.equals((Object)SchemaType.MARC21)) {
            return new RecordFilterMarc21(allowableRecordsInput);
        }
        if (type2.equals((Object)SchemaType.PICA)) {
            return new RecordFilterPica(allowableRecordsInput);
        }
        throw new IllegalArgumentException("Unsupported schema type");
    }
}

