/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.cli.utils.ignorablerecords;

import de.gwdg.metadataqa.marc.MarcSubfield;
import de.gwdg.metadataqa.marc.dao.DataField;
import de.gwdg.metadataqa.marc.dao.record.BibliographicRecord;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class Marc21Filter {
    protected List<DataField> conditions;

    protected void parseInput(String input) {
        if (StringUtils.isNotBlank(input)) {
            this.conditions = new ArrayList<DataField>();
            for (String field : input.split(",")) {
                DataField f = this.parseField(field);
                if (f == null) continue;
                this.conditions.add(f);
            }
        }
    }

    public List<DataField> getConditions() {
        return this.conditions;
    }

    public boolean isEmpty() {
        return this.conditions == null || this.conditions.isEmpty();
    }

    protected DataField parseField(String field) {
        Pattern pattern = Pattern.compile("^(.{3})\\$(.)=(.*)$");
        Matcher matcher = pattern.matcher(field);
        if (matcher.matches()) {
            String tag = matcher.group(1);
            String subfield = matcher.group(2);
            String value = matcher.group(3);
            return new DataField(tag, "  $" + subfield + value);
        }
        return null;
    }

    protected boolean met(BibliographicRecord marcRecord) {
        for (DataField condition : this.conditions) {
            boolean passed;
            List<DataField> recordFields = marcRecord.getDatafield(condition.getTag());
            if (recordFields == null || recordFields.isEmpty() || !(passed = this.metCondition(condition, recordFields))) continue;
            return true;
        }
        return false;
    }

    private boolean metCondition(DataField condition, List<DataField> recordFields) {
        for (DataField recordField : recordFields) {
            MarcSubfield subfieldCond;
            String code;
            List<MarcSubfield> recordSubfields = recordField.getSubfield(code = (subfieldCond = condition.getSubfields().get(0)).getCode());
            if (recordSubfields == null || recordSubfields.isEmpty()) continue;
            for (MarcSubfield recordSubfield : recordSubfields) {
                if (!recordSubfield.getValue().equals(subfieldCond.getValue())) continue;
                return true;
            }
        }
        return false;
    }
}

