/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.cli.utils.ignorablerecords;

import de.gwdg.metadataqa.marc.MarcSubfield;
import de.gwdg.metadataqa.marc.cli.utils.ignorablerecords.Operator;
import de.gwdg.metadataqa.marc.dao.DataField;
import de.gwdg.metadataqa.marc.dao.record.BibliographicRecord;
import de.gwdg.metadataqa.marc.utils.pica.path.PicaPath;
import de.gwdg.metadataqa.marc.utils.pica.path.Subfields;
import java.util.List;
import java.util.regex.Pattern;

public class CriteriumPica {
    private PicaPath path;
    private Operator operator;
    private String value;
    private Pattern pattern;

    public CriteriumPica(PicaPath path, Operator operator, String value) {
        this.path = path;
        this.operator = operator;
        this.value = value;
        if (operator.equals((Object)Operator.MATCH) || operator.equals((Object)Operator.NOT_MATCH)) {
            this.pattern = Pattern.compile(value);
        }
    }

    public PicaPath getPath() {
        return this.path;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public String getValue() {
        return this.value;
    }

    public boolean met(BibliographicRecord marcRecord) {
        Subfields subfieldsSelector;
        List<DataField> fields2 = marcRecord.getDatafield(this.path.getTag());
        boolean passed = false;
        if (fields2 != null && !fields2.isEmpty() && (subfieldsSelector = this.path.getSubfields()) != null) {
            passed = subfieldsSelector.getType().equals((Object)Subfields.Type.ALL) ? this.metFields(fields2, null) : this.metFields(fields2, subfieldsSelector.getCodes());
        }
        return passed;
    }

    public boolean metFields(List<DataField> fields2, List<String> codes) {
        for (DataField field : fields2) {
            boolean passed = false;
            if (codes == null && (passed = this.metSubfields(field.getSubfields()))) {
                return true;
            }
            for (String code : codes) {
                passed = this.metSubfields(field.getSubfield(code));
                if (!passed) continue;
                return true;
            }
        }
        return false;
    }

    public boolean metSubfields(List<MarcSubfield> subfieldInstances) {
        switch (this.operator) {
            case EXIST: {
                return subfieldInstances != null && !subfieldInstances.isEmpty();
            }
            case MATCH: {
                return this.subfieldMatches(subfieldInstances);
            }
            case NOT_MATCH: {
                return !this.subfieldMatches(subfieldInstances);
            }
            case EQUAL: {
                return this.subfieldEquals(subfieldInstances);
            }
            case NOT_EQUAL: {
                return !this.subfieldEquals(subfieldInstances);
            }
            case START_WITH: {
                return this.subfieldStartsWith(subfieldInstances);
            }
            case END_WITH: {
                return this.subfieldEndsWith(subfieldInstances);
            }
        }
        return false;
    }

    private boolean subfieldMatches(List<MarcSubfield> instances) {
        if (instances != null && !instances.isEmpty()) {
            for (MarcSubfield instance : instances) {
                if (!this.pattern.matcher(instance.getValue()).find()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean subfieldEquals(List<MarcSubfield> instances) {
        if (instances != null && !instances.isEmpty()) {
            for (MarcSubfield instance : instances) {
                if (!this.value.equals(instance.getValue())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean subfieldStartsWith(List<MarcSubfield> instances) {
        if (instances != null && !instances.isEmpty()) {
            for (MarcSubfield instance : instances) {
                if (!instance.getValue().startsWith(this.value)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean subfieldEndsWith(List<MarcSubfield> instances) {
        if (instances != null && !instances.isEmpty()) {
            for (MarcSubfield instance : instances) {
                if (!instance.getValue().endsWith(this.value)) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "CriteriumPica{path=" + this.path.getPath() + ", operator=" + this.operator + ", value='" + this.value + "'}";
    }
}

