/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.cli.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class IgnorableFields {
    private List<String> fields;
    private List<Pattern> maskedFields;

    public void parseFields(String raw) {
        if (StringUtils.isNotBlank(raw)) {
            this.fields = new ArrayList<String>();
            this.maskedFields = new ArrayList<Pattern>();
            List<String> candidates = Arrays.asList(raw.split(","));
            for (String candidate : candidates) {
                if (candidate.contains(".")) {
                    this.maskedFields.add(Pattern.compile(candidate));
                    continue;
                }
                this.fields.add(candidate);
            }
        }
    }

    public boolean isEmpty() {
        return !(this.fields != null && !this.fields.isEmpty() || this.maskedFields != null && !this.maskedFields.isEmpty());
    }

    public List<String> getFields() {
        return this.fields;
    }

    public boolean contains(String tag) {
        if (this.isEmpty()) {
            return false;
        }
        if (this.fields.contains(tag)) {
            return true;
        }
        if (!this.maskedFields.isEmpty()) {
            for (Pattern pattern : this.maskedFields) {
                if (!pattern.matcher(tag).matches()) continue;
                this.fields.add(tag);
                return true;
            }
        }
        return false;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "";
        }
        Object value = "";
        if (!this.fields.isEmpty()) {
            value = (String)value + StringUtils.join(this.fields, ", ");
        }
        if (!this.maskedFields.isEmpty()) {
            value = (String)value + (((String)value).equals("") ? "" : ", ");
            value = (String)value + "masked fields: " + StringUtils.join(this.maskedFields, ", ");
        }
        return value;
    }
}

