/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.cli.utils;

import de.gwdg.metadataqa.marc.Utils;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class Collocation {
    String key;
    Integer count;
    double percent;

    public Collocation(List<String> key, Integer count, Integer total) {
        this.key = StringUtils.join(key, ";");
        this.count = count;
        this.percent = (double)count.intValue() * 100.0 / (double)total.intValue();
    }

    public static String header() {
        return Utils.createRow("abbreviations", "recordcount", "percent");
    }

    public String formatRow() {
        return Utils.createRow(this.key, this.count, String.format("%.2f%%", this.percent));
    }

    public int compareTo(Collocation other) {
        int i = this.getCount().compareTo(other.getCount());
        if (i == 0) {
            i = this.getKey().compareTo(other.getKey());
        }
        return i;
    }

    public String getKey() {
        return this.key;
    }

    public Integer getCount() {
        return this.count;
    }
}

