/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.cli.parameters;

import de.gwdg.metadataqa.api.rule.RuleCheckingOutputType;
import de.gwdg.metadataqa.marc.cli.parameters.CommonParameters;
import org.apache.commons.cli.ParseException;

public class Shacl4bibParameters
extends CommonParameters {
    private static final String DEFAULT_SHACL_OUTPUT_FILE = "shacl4bib.csv";
    private static final RuleCheckingOutputType DEFAULT_SHACL_OUTPUT_TYPE = RuleCheckingOutputType.STATUS;
    private boolean isOptionSet = false;
    private String shaclConfigurationFile;
    private String shaclOutputFile = "shacl4bib.csv";
    private RuleCheckingOutputType shaclOutputType = DEFAULT_SHACL_OUTPUT_TYPE;

    @Override
    protected void setOptions() {
        if (!this.isOptionSet) {
            super.setOptions();
            this.options.addOption("C", "shaclConfigurationFile", true, "specify the configuration file");
            this.options.addOption("O", "shaclOutputFile", true, "output file");
            this.options.addOption("P", "shaclOutputType", true, "output type (STATUS: status only, SCORE: score only, BOTH: status and score");
            this.isOptionSet = true;
        }
    }

    public Shacl4bibParameters() {
    }

    public Shacl4bibParameters(String[] arguments2) throws ParseException {
        super(arguments2);
        if (this.cmd.hasOption("shaclConfigurationFile")) {
            this.shaclConfigurationFile = this.cmd.getOptionValue("shaclConfigurationFile");
        }
        if (this.cmd.hasOption("shaclOutputFile")) {
            this.shaclOutputFile = this.cmd.getOptionValue("shaclOutputFile");
        }
        if (this.cmd.hasOption("shaclOutputType")) {
            this.shaclOutputType = RuleCheckingOutputType.valueOf(this.cmd.getOptionValue("shaclOutputType"));
        }
    }

    public String getShaclConfigurationFile() {
        return this.shaclConfigurationFile;
    }

    public String getShaclOutputFile() {
        return this.shaclOutputFile;
    }

    public RuleCheckingOutputType getShaclOutputType() {
        return this.shaclOutputType;
    }

    @Override
    public String formatParameters() {
        Object text = super.formatParameters();
        text = (String)text + String.format("shaclConfigurationFile: %s%n", this.shaclConfigurationFile);
        text = (String)text + String.format("shaclOutputFile: %s%n", this.shaclOutputFile);
        text = (String)text + String.format("shaclOutputType: %s%n", new Object[]{this.shaclOutputType});
        return text;
    }
}

