/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.cli.parameters;

import de.gwdg.metadataqa.marc.cli.parameters.CommonParameters;
import de.gwdg.metadataqa.marc.model.SolrFieldType;
import org.apache.commons.cli.ParseException;
import org.apache.solr.client.solrj.SolrClient;

public class MarcToSolrParameters
extends CommonParameters {
    private boolean useEmbedded = false;
    private String solrUrl = null;
    private boolean doCommit = false;
    private SolrFieldType solrFieldType = SolrFieldType.MARC;
    private String validationUrl = null;
    private SolrClient mainClient = null;
    private SolrClient validationClient = null;
    private boolean isOptionSet = false;

    @Override
    protected void setOptions() {
        if (!this.isOptionSet) {
            super.setOptions();
            this.options.addOption("s", "solrUrl", true, "the URL of Solr server");
            this.options.addOption("c", "doCommit", false, "send commits to Solr regularly");
            this.options.addOption("t", "solrFieldType", true, "type of Solr fields, could be one of 'marc-tags', 'human-readable', or 'mixed'");
            this.options.addOption("A", "validationUrl", true, "the URL of the Solr used in validation");
            this.options.addOption("B", "useEmbedded", false, "use embedded Solr server (used in tests only)");
            this.isOptionSet = true;
        }
    }

    public MarcToSolrParameters(String[] arguments2) throws ParseException {
        super(arguments2);
        if (this.cmd.hasOption("solrUrl")) {
            this.solrUrl = this.cmd.getOptionValue("solrUrl");
        }
        if (this.cmd.hasOption("doCommit")) {
            this.doCommit = true;
        }
        if (this.cmd.hasOption("solrFieldType")) {
            this.solrFieldType = SolrFieldType.byCode(this.cmd.getOptionValue("solrFieldType"));
        }
        if (this.cmd.hasOption("validationUrl")) {
            this.validationUrl = this.cmd.getOptionValue("validationUrl");
        }
        if (this.cmd.hasOption("useEmbedded")) {
            this.useEmbedded = true;
        }
    }

    public String getSolrUrl() {
        return this.solrUrl;
    }

    public boolean doCommit() {
        return this.doCommit;
    }

    public SolrFieldType getSolrFieldType() {
        return this.solrFieldType;
    }

    public String getValidationUrl() {
        return this.validationUrl;
    }

    public SolrClient getMainClient() {
        return this.mainClient;
    }

    public void setMainClient(SolrClient mainClient) {
        this.mainClient = mainClient;
    }

    public SolrClient getValidationClient() {
        return this.validationClient;
    }

    public void setValidationClient(SolrClient validationClient) {
        this.validationClient = validationClient;
    }

    public boolean useEmbedded() {
        return this.useEmbedded;
    }

    @Override
    public String formatParameters() {
        Object text = super.formatParameters();
        text = (String)text + String.format("solrUrl: %s%n", this.solrUrl);
        text = (String)text + String.format("doCommit: %s%n", this.doCommit);
        text = (String)text + String.format("solrFieldType: %s%n", new Object[]{this.solrFieldType});
        text = (String)text + String.format("validationUrl: %s%n", this.validationUrl);
        return text;
    }
}

