/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.cli.parameters;

import de.gwdg.metadataqa.marc.cli.parameters.CommonParameters;
import de.gwdg.metadataqa.marc.definition.bibliographic.SchemaType;
import de.gwdg.metadataqa.marc.utils.SchemaSpec;
import de.gwdg.metadataqa.marc.utils.marcspec.legacy.MarcSpec;
import de.gwdg.metadataqa.marc.utils.pica.path.PicaSpec;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.StringUtils;

public class FormatterParameters
extends CommonParameters {
    public static final String DEFAULT_FILE_NAME = "extracted.csv";
    private String format = null;
    private int countNr = -1;
    private String search = null;
    private String path = null;
    private String query = null;
    private List<SchemaSpec> selector = null;
    private boolean withId = false;
    private String separator = "\t";
    private String fileName = "extracted.csv";
    private boolean isOptionSet = false;

    @Override
    protected void setOptions() {
        if (!this.isOptionSet) {
            super.setOptions();
            this.options.addOption("f", "format", true, "specify a format");
            this.options.addOption("c", "countNr", true, "count number of the record (e.g. 1 means the first record)");
            this.options.addOption("s", "search", true, "search string ([path]=[value])");
            this.options.addOption("l", "selector", true, "selectors");
            this.options.addOption("w", "withId", false, "the generated CSV should contain record ID as first field");
            this.options.addOption("p", "separator", true, "separator between the parts (default: TAB)");
            this.options.addOption("e", "fileName", true, String.format("output file (default: %s)", DEFAULT_FILE_NAME));
            this.isOptionSet = true;
        }
    }

    public FormatterParameters(String[] arguments2) throws ParseException {
        super(arguments2);
        if (this.cmd.hasOption("format")) {
            this.format = this.cmd.getOptionValue("format");
        }
        if (this.cmd.hasOption("countNr")) {
            this.countNr = Integer.parseInt(this.cmd.getOptionValue("countNr"));
        }
        if (this.cmd.hasOption("search")) {
            this.search = this.cmd.getOptionValue("search");
            String[] parts = this.search.split("=", 2);
            this.path = parts[0];
            this.query = parts[1];
        }
        if (this.cmd.hasOption("selector")) {
            String rawSelector = this.cmd.getOptionValue("selector");
            String[] rawSelectors = rawSelector.split(";");
            this.selector = new ArrayList<SchemaSpec>();
            if (this.getSchemaType().equals((Object)SchemaType.MARC21)) {
                for (String _rawSelector : rawSelectors) {
                    this.selector.add(new MarcSpec(_rawSelector));
                }
            } else if (this.getSchemaType().equals((Object)SchemaType.PICA)) {
                for (String _rawSelector : rawSelectors) {
                    this.selector.add(new PicaSpec(_rawSelector));
                }
            }
        }
        this.withId = this.cmd.hasOption("withId");
        if (this.cmd.hasOption("separator")) {
            this.separator = this.cmd.getOptionValue("separator");
        }
        if (this.cmd.hasOption("fileName")) {
            this.fileName = this.cmd.getOptionValue("fileName");
        }
    }

    public String getFormat() {
        return this.format;
    }

    public int getCountNr() {
        return this.countNr;
    }

    public String getSearch() {
        return this.search;
    }

    public boolean hasSearch() {
        return StringUtils.isNotBlank(this.path) && StringUtils.isNotBlank(this.query);
    }

    public String getPath() {
        return this.path;
    }

    public String getQuery() {
        return this.query;
    }

    public List<SchemaSpec> getSelector() {
        return this.selector;
    }

    public boolean hasSelector() {
        return this.selector != null && !this.selector.isEmpty();
    }

    public boolean withId() {
        return this.withId;
    }

    public String getSeparator() {
        return this.separator;
    }

    public String getFileName() {
        return this.fileName;
    }

    @Override
    public String formatParameters() {
        Object text = super.formatParameters();
        text = (String)text + String.format("format: %s%n", this.format);
        text = (String)text + String.format("countNr: %s%n", this.countNr);
        text = (String)text + String.format("search: %s%n", this.search);
        text = (String)text + String.format("withId: %s%n", this.withId);
        text = (String)text + String.format("separator: %s%n", this.separator);
        text = (String)text + String.format("outputFile: %s%n", this.fileName);
        return text;
    }
}

