/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.cli;

import de.gwdg.metadataqa.api.configuration.ConfigurationReader;
import de.gwdg.metadataqa.api.configuration.SchemaConfiguration;
import de.gwdg.metadataqa.api.rule.RuleCatalog;
import de.gwdg.metadataqa.marc.CsvUtils;
import de.gwdg.metadataqa.marc.RuleCatalogUtils;
import de.gwdg.metadataqa.marc.cli.QACli;
import de.gwdg.metadataqa.marc.cli.parameters.CommonParameters;
import de.gwdg.metadataqa.marc.cli.parameters.Shacl4bibParameters;
import de.gwdg.metadataqa.marc.cli.processor.BibliographicInputProcessor;
import de.gwdg.metadataqa.marc.cli.utils.BibSelector;
import de.gwdg.metadataqa.marc.cli.utils.BibSelectorFactory;
import de.gwdg.metadataqa.marc.cli.utils.RecordIterator;
import de.gwdg.metadataqa.marc.dao.record.BibliographicRecord;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.FileUtils;
import org.marc4j.marc.Record;

public class Shacl4bib
extends QACli
implements BibliographicInputProcessor,
Serializable {
    private static final Logger logger = Logger.getLogger(Shacl4bib.class.getCanonicalName());
    private final boolean readyToProcess;
    private Shacl4bibParameters parameters;
    private File outputFile;
    private RuleCatalog ruleCatalog;
    private SchemaConfiguration schema;

    public Shacl4bib(String[] args2) throws ParseException {
        this.parameters = new Shacl4bibParameters(args2);
        this.readyToProcess = true;
    }

    public static void main(String[] args2) {
        Shacl4bib processor = null;
        try {
            processor = new Shacl4bib(args2);
        }
        catch (ParseException e) {
            System.err.println("ERROR. " + e.getLocalizedMessage());
            System.exit(0);
        }
        if (processor.getParameters().getArgs().length < 1) {
            System.err.println("Please provide a MARC file name!");
            processor.printHelp(processor.getParameters().getOptions());
            System.exit(0);
        }
        if (processor.getParameters().doHelp()) {
            processor.printHelp(processor.getParameters().getOptions());
            System.exit(0);
        }
        RecordIterator iterator2 = new RecordIterator(processor);
        iterator2.start();
    }

    @Override
    public CommonParameters getParameters() {
        return this.parameters;
    }

    @Override
    public void beforeIteration() {
        logger.info(this.parameters.formatParameters());
        this.outputFile = new File(this.parameters.getOutputDir(), this.parameters.getShaclOutputFile());
        String shaclConfigurationFile = this.parameters.getShaclConfigurationFile();
        try {
            this.schema = shaclConfigurationFile.endsWith(".json") ? ConfigurationReader.readSchemaJson(shaclConfigurationFile) : ConfigurationReader.readSchemaYaml(shaclConfigurationFile);
        }
        catch (IOException exception) {
            logger.severe("Error when the SHACL schema is initialized. " + exception.getLocalizedMessage());
            System.exit(0);
        }
        this.ruleCatalog = new RuleCatalog(this.schema.asSchema()).setOnlyIdInHeader(true).setOutputType(this.parameters.getShaclOutputType());
        if (this.outputFile.exists() && !this.outputFile.delete()) {
            logger.log(Level.SEVERE, "The output file ({}) has not been deleted", this.outputFile.getAbsolutePath());
        }
        List<String> header = this.ruleCatalog.getHeader();
        header.add(0, "id");
        this.printToFile(this.outputFile, CsvUtils.createCsv(header));
        this.saveParameters("shacl.params.json", this.parameters);
    }

    @Override
    public void fileOpened(Path path) {
        logger.log(Level.INFO, "file opened: {0}", new Object[]{path});
    }

    @Override
    public void processRecord(Record marc4jRecord, int recordNumber) throws IOException {
    }

    @Override
    public void processRecord(BibliographicRecord marcRecord, int recordNumber) throws IOException {
        BibSelector selector = BibSelectorFactory.create(this.schema.getFormat(), marcRecord);
        if (selector != null) {
            List<Object> values2 = RuleCatalogUtils.extract(this.ruleCatalog, this.ruleCatalog.measure(selector));
            values2.add(0, marcRecord.getId(true));
            this.printToFile(this.outputFile, CsvUtils.createCsvFromObjects(values2));
        }
    }

    @Override
    public void fileProcessed() {
    }

    @Override
    public void afterIteration(int numberOfprocessedRecords) {
        this.copySchaclFileToOutputDir();
    }

    private void copySchaclFileToOutputDir() {
        File source2 = new File(this.parameters.getShaclConfigurationFile());
        try {
            FileUtils.copyFileToDirectory(source2, new File(this.parameters.getOutputDir()));
        }
        catch (IOException e) {
            logger.warning(e.getLocalizedMessage());
        }
    }

    @Override
    public void printHelp(Options options) {
    }

    @Override
    public boolean readyToProcess() {
        return this.readyToProcess;
    }
}

