/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.cli;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.gwdg.metadataqa.marc.CsvUtils;
import de.gwdg.metadataqa.marc.cli.Version;
import de.gwdg.metadataqa.marc.cli.parameters.CommonParameters;
import de.gwdg.metadataqa.marc.dao.record.BibliographicRecord;
import de.gwdg.metadataqa.marc.utils.BibiographicPath;
import de.gwdg.metadataqa.marc.utils.pica.path.PicaPath;
import de.gwdg.metadataqa.marc.utils.pica.path.PicaPathParser;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class QACli {
    private static final Logger logger = Logger.getLogger(QACli.class.getCanonicalName());
    public static final String ALL = "0";
    protected BibiographicPath groupBy = null;
    protected File idCollectorFile;
    private FileTime jarModifiedTime;
    private boolean isJarModifiedTimeDetected = false;
    protected boolean doSaveGroupIds = true;

    protected void initializeGroups(String groupBy, boolean isPica) {
        if (groupBy != null) {
            this.groupBy = isPica ? PicaPathParser.parse(groupBy) : null;
        }
    }

    protected <T extends CommonParameters> void saveParameters(String fileName, T parameters2) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            String json = mapper.writeValueAsString(parameters2);
            Map<String, Object> configuration = mapper.readValue(json, new TypeReference<Map<String, Object>>(){});
            configuration.put("mqaf.version", de.gwdg.metadataqa.api.cli.Version.getVersion());
            configuration.put("qa-catalogue.version", Version.getVersion());
            File configFile = Paths.get(parameters2.getOutputDir(), fileName).toFile();
            logger.log(Level.INFO, "Saving configuration to {0}.", configFile.getAbsolutePath());
            mapper.writeValue(configFile, configuration);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected Set<String> getGroupIds(CommonParameters parameters2, BibliographicRecord bibliographicRecord) {
        if (this.groupBy != null) {
            List<String> idLists = parameters2.isPica() ? bibliographicRecord.select((PicaPath)this.groupBy) : null;
            return QACli.extractGroupIds(idLists);
        }
        return new HashSet<String>();
    }

    protected void saveGroupIds(String recordId, Set<String> groupIds) {
        if (this.doGroups() && !groupIds.isEmpty()) {
            for (String groupId : groupIds) {
                this.printToFile(this.idCollectorFile, CsvUtils.createCsv(recordId, groupId));
            }
        }
    }

    public static Set<String> extractGroupIds(List<String> idLists) {
        HashSet<String> groupIds = new HashSet<String>();
        groupIds.add(ALL);
        if (idLists != null) {
            for (String idList : idLists) {
                String[] ids = idList.split(",");
                groupIds.addAll(Arrays.asList(ids));
            }
        }
        return groupIds;
    }

    public boolean doGroups() {
        return this.groupBy != null;
    }

    protected boolean isJarNewerThan(String outputDir, String fileName) {
        try {
            this.initializeJarModifiedTime();
            File reportFile = new File(outputDir, fileName);
            if (!reportFile.exists()) {
                return true;
            }
            FileTime groupModifiedTime = Files.readAttributes(reportFile.toPath(), BasicFileAttributes.class, new LinkOption[0]).lastModifiedTime();
            return this.jarModifiedTime == null || this.jarModifiedTime.compareTo(groupModifiedTime) > 0;
        }
        catch (IOException e) {
            logger.severe("Error during prepareReportFile: " + e);
            return false;
        }
    }

    protected void initializeMeta(CommonParameters parameters2) {
        File idCollectorMeta = new File(parameters2.getOutputDir(), "id-groupid.meta.txt");
        String currentFileList = this.getFilesWithDate(parameters2.getArgs());
        if (this.isJarNewerThan(parameters2.getOutputDir(), "id-groupid.csv")) {
            if (!idCollectorMeta.delete()) {
                logger.severe("id-groupid.meta.txt has not been deleted.");
            }
        } else if (idCollectorMeta.exists()) {
            try {
                String storedFileList = FileUtils.readFileToString(idCollectorMeta, StandardCharsets.UTF_8).trim();
                boolean bl = this.doSaveGroupIds = !currentFileList.equals(storedFileList);
                if (!idCollectorMeta.delete()) {
                    logger.severe("id-groupid.meta.txt has not been deleted.");
                }
            }
            catch (IOException e) {
                logger.severe(e.getLocalizedMessage());
            }
        }
        this.printToFile(idCollectorMeta, currentFileList);
    }

    private String getFilesWithDate(String[] fileNames) {
        ArrayList<CallSite> filesWithDate = new ArrayList<CallSite>();
        for (String fileName : fileNames) {
            try {
                FileTime modifiedTime = Files.readAttributes(new File(fileName).toPath(), BasicFileAttributes.class, new LinkOption[0]).lastModifiedTime();
                filesWithDate.add((CallSite)((Object)(fileName + ":" + modifiedTime.toString())));
            }
            catch (IOException e) {
                logger.warning(e.getLocalizedMessage());
            }
        }
        return StringUtils.join(filesWithDate, ",");
    }

    protected File prepareReportFile(String outputDir, String fileName) {
        File reportFile = new File(outputDir, fileName);
        if (reportFile.exists() && !reportFile.delete()) {
            logger.log(Level.SEVERE, "File {0} hasn't been deleted", new Object[]{reportFile.getAbsolutePath()});
        }
        return reportFile;
    }

    protected void printToFile(File file, String content) {
        try {
            FileUtils.writeStringToFile(file, content, Charset.defaultCharset(), true);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "printToFile", e);
        }
    }

    private void initializeJarModifiedTime() {
        if (!this.isJarModifiedTimeDetected) {
            try {
                File currentJar = new File(this.getClass().getProtectionDomain().getCodeSource().getLocation().toURI());
                if (currentJar.isFile()) {
                    this.jarModifiedTime = Files.readAttributes(currentJar.toPath(), BasicFileAttributes.class, new LinkOption[0]).lastModifiedTime();
                }
            }
            catch (IOException | URISyntaxException e) {
                throw new RuntimeException(e);
            }
            this.isJarModifiedTimeDetected = true;
        }
    }
}

