/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.cli;

import de.gwdg.metadataqa.marc.MarcSubfield;
import de.gwdg.metadataqa.marc.Utils;
import de.gwdg.metadataqa.marc.cli.parameters.CompletenessParameters;
import de.gwdg.metadataqa.marc.cli.processor.BibliographicInputProcessor;
import de.gwdg.metadataqa.marc.cli.utils.RecordIterator;
import de.gwdg.metadataqa.marc.dao.DataField;
import de.gwdg.metadataqa.marc.dao.MarcControlField;
import de.gwdg.metadataqa.marc.dao.MarcPositionalControlField;
import de.gwdg.metadataqa.marc.dao.record.BibliographicRecord;
import de.gwdg.metadataqa.marc.definition.ControlValue;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.bibliographic.SchemaType;
import de.gwdg.metadataqa.marc.definition.structure.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.Indicator;
import de.gwdg.metadataqa.marc.model.validation.ValidationErrorFormat;
import de.gwdg.metadataqa.marc.utils.Counter;
import de.gwdg.metadataqa.marc.utils.FrbrFunctionLister;
import de.gwdg.metadataqa.marc.utils.FunctionValue;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.marc4j.marc.Record;

public class FunctionalAnalysis
implements BibliographicInputProcessor,
Serializable {
    private static final Logger logger = Logger.getLogger(FunctionalAnalysis.class.getCanonicalName());
    private final Options options;
    private final boolean readyToProcess;
    private final CompletenessParameters parameters;
    private FrbrFunctionLister frbrFunctionLister;
    private int recordNumber;

    public FunctionalAnalysis(String[] args2) throws ParseException {
        this.parameters = new CompletenessParameters(args2);
        this.options = this.parameters.getOptions();
        this.readyToProcess = true;
        this.frbrFunctionLister = new FrbrFunctionLister(this.parameters.getSchemaType(), this.parameters.getMarcVersion());
        logger.info(this.frbrFunctionLister.getBaseline().toString());
    }

    public static void main(String[] args2) {
        FunctionalAnalysis processor = null;
        try {
            processor = new FunctionalAnalysis(args2);
        }
        catch (ParseException e) {
            logger.log(Level.SEVERE, "FunctionalAnalysis", e);
            System.exit(0);
        }
        if (processor.getParameters().getArgs().length < 1) {
            logger.severe("Please provide a MARC file name!");
            processor.printHelp(processor.getParameters().getOptions());
            System.exit(0);
        }
        if (processor.getParameters().doHelp()) {
            processor.printHelp(processor.getParameters().getOptions());
            System.exit(0);
        }
        RecordIterator iterator2 = new RecordIterator(processor);
        iterator2.start();
    }

    @Override
    public CompletenessParameters getParameters() {
        return this.parameters;
    }

    @Override
    public void processRecord(Record marc4jRecord, int recordNumber) throws IOException {
    }

    @Override
    public void processRecord(BibliographicRecord bibliographicRecord, int recordNumber) throws IOException {
        if (this.parameters.getRecordIgnorator().isIgnorable(bibliographicRecord)) {
            return;
        }
        this.recordNumber = recordNumber;
        TreeMap<FRBRFunction, FunctionValue> recordCounter = new TreeMap<FRBRFunction, FunctionValue>();
        for (FRBRFunction f : FRBRFunction.values()) {
            if (f.getParent() == null) continue;
            recordCounter.put(f, new FunctionValue());
        }
        HashMap<DataFieldDefinition, Boolean> cache2 = new HashMap<DataFieldDefinition, Boolean>();
        if (bibliographicRecord.getSchemaType().equals((Object)SchemaType.MARC21)) {
            this.countPositionalControlField(recordCounter, bibliographicRecord.getLeader());
            this.countControlFields(recordCounter, bibliographicRecord.getControlfields());
        }
        this.countDataFields(recordCounter, bibliographicRecord.getDatafields(), bibliographicRecord.getSchemaType(), cache2);
        this.frbrFunctionLister.calculatePercent(recordCounter);
        this.frbrFunctionLister.add(recordCounter);
        this.frbrFunctionLister.addToHistogram(recordCounter);
    }

    private void countDataFields(Map<FRBRFunction, FunctionValue> recordCounter, List<DataField> dataFields, SchemaType schemaType, Map<DataFieldDefinition, Boolean> cache2) {
        for (DataField dataField : dataFields) {
            DataFieldDefinition definition = dataField.getDefinition();
            if (cache2.containsKey(definition)) continue;
            cache2.put(definition, true);
            if (definition != null && schemaType.equals((Object)SchemaType.MARC21)) {
                this.countIndicator(recordCounter, definition.getInd1(), dataField.getInd1());
                this.countIndicator(recordCounter, definition.getInd2(), dataField.getInd2());
            }
            if (schemaType.equals((Object)SchemaType.MARC21)) {
                for (MarcSubfield subfield : dataField.getSubfields()) {
                    if (subfield.getDefinition() == null || subfield.getDefinition().getFrbrFunctions() == null) continue;
                    FrbrFunctionLister.countFunctions(subfield.getDefinition().getFrbrFunctions(), recordCounter);
                }
                continue;
            }
            if (!schemaType.equals((Object)SchemaType.PICA)) continue;
            for (MarcSubfield subfield : dataField.getSubfields()) {
                String key = dataField.getTag() + "$" + subfield.getCode();
                if (!this.frbrFunctionLister.getFunctionByPicaPath().containsKey(key)) continue;
                FrbrFunctionLister.countFunctions(this.frbrFunctionLister.getFunctionByPicaPath().get(key), recordCounter);
            }
        }
    }

    private void countIndicator(Map<FRBRFunction, FunctionValue> recordCounter, Indicator definition, String value) {
        if (definition.getFrbrFunctions() != null && StringUtils.isNotBlank(value)) {
            FrbrFunctionLister.countFunctions(definition.getFrbrFunctions(), recordCounter);
        }
    }

    private void countControlFields(Map<FRBRFunction, FunctionValue> recordCounter, List<MarcControlField> controlFields) {
        for (MarcControlField controlField : controlFields) {
            if (controlField == null) continue;
            if (controlField instanceof MarcPositionalControlField) {
                this.countPositionalControlField(recordCounter, (MarcPositionalControlField)controlField);
                continue;
            }
            FrbrFunctionLister.countFunctions(controlField.getDefinition().getFrbrFunctions(), recordCounter);
        }
    }

    private void countPositionalControlField(Map<FRBRFunction, FunctionValue> recordCounter, MarcPositionalControlField leader) {
        for (ControlValue controlValue : leader.getValuesList()) {
            FrbrFunctionLister.countFunctions(controlValue.getDefinition().getFrbrFunctions(), recordCounter);
        }
    }

    @Override
    public void beforeIteration() {
    }

    @Override
    public void fileOpened(Path path) {
    }

    @Override
    public void fileProcessed() {
    }

    @Override
    public void afterIteration(int numberOfprocessedRecords) {
        String fileExtension = ".csv";
        char separator = this.getSeparator(this.parameters.getFormat());
        if (this.parameters.getFormat().equals((Object)ValidationErrorFormat.TAB_SEPARATED)) {
            fileExtension = ".tsv";
        }
        Map<FRBRFunction, List<Double>> result2 = this.frbrFunctionLister.percentOf(this.recordNumber);
        this.saveResult(result2, fileExtension, separator);
        Map<FRBRFunction, Counter<FunctionValue>> percentHistogram = this.frbrFunctionLister.getHistogram();
        this.saveHistogram(percentHistogram, fileExtension, separator);
        this.saveMapping(fileExtension, separator);
    }

    private void saveMapping(String fileExtension, char separator) {
        Map<FRBRFunction, List<String>> functions2 = null;
        if (this.parameters.getSchemaType().equals((Object)SchemaType.MARC21)) {
            functions2 = this.frbrFunctionLister.getMarcPathByFunction();
        } else if (this.parameters.getSchemaType().equals((Object)SchemaType.PICA)) {
            functions2 = this.frbrFunctionLister.getPicaPathByFunctionConcensed();
        }
        Path path = Paths.get(this.parameters.getOutputDir(), "functional-analysis-mapping" + fileExtension);
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            writer.write("frbrfunction" + separator + "count" + separator + "fields\n");
            for (FRBRFunction function : FRBRFunction.values()) {
                if (function.getParent() == null) continue;
                ArrayList paths = functions2 != null ? (List)functions2.getOrDefault((Object)function, new ArrayList()) : new ArrayList();
                ArrayList<Object> cells = new ArrayList<Object>();
                cells.add(function.toString());
                cells.add(paths.size());
                cells.add(StringUtils.join(paths, ";"));
                writer.write(Utils.createRow(cells));
            }
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "afterIteration", e);
        }
    }

    private void saveHistogram(Map<FRBRFunction, Counter<FunctionValue>> histogram, String fileExtension, char separator) {
        logger.info("Functional analysis histogram");
        Path path = Paths.get(this.parameters.getOutputDir(), "functional-analysis-histogram" + fileExtension);
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            writer.write("frbrfunction" + separator + "functioncount" + separator + "score" + separator + "count\n");
            histogram.entrySet().stream().forEach(entry -> {
                String function = ((FRBRFunction)((Object)((Object)entry.getKey()))).name();
                Map histogramOfFunction = ((Counter)entry.getValue()).getMap();
                histogramOfFunction.keySet().stream().sorted((a, b) -> Integer.valueOf(a.getCount()).compareTo(b.getCount())).forEach(functionValue -> {
                    Integer count = (Integer)histogramOfFunction.get(functionValue);
                    try {
                        writer.write(Utils.createRow(function, functionValue.getCount(), functionValue.getPercent(), count));
                    }
                    catch (IOException e) {
                        logger.log(Level.SEVERE, "saveHistogram", e);
                    }
                });
            });
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "saveHistogram", e);
        }
    }

    private void saveResult(Map<FRBRFunction, List<Double>> result2, String fileExtension, char separator) {
        logger.info("Saving functional analysis");
        Path path = Paths.get(this.parameters.getOutputDir(), "functional-analysis" + fileExtension);
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            writer.write("frbr-function" + separator + "avgcount" + separator + "avgscore\n");
            result2.entrySet().stream().forEach(entry -> {
                try {
                    List values2 = (List)entry.getValue();
                    writer.write(Utils.createRow(((FRBRFunction)((Object)((Object)entry.getKey()))).name(), values2.get(0), values2.get(1)));
                }
                catch (IOException e) {
                    logger.log(Level.SEVERE, "saveResult", e);
                }
            });
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "saveResult", e);
        }
    }

    private char getSeparator(ValidationErrorFormat format) {
        if (format.equals((Object)ValidationErrorFormat.TAB_SEPARATED)) {
            return '\t';
        }
        return ',';
    }

    @Override
    public void printHelp(Options options) {
    }

    @Override
    public boolean readyToProcess() {
        return this.readyToProcess;
    }

    public FrbrFunctionLister getFrbrFunctionLister() {
        return this.frbrFunctionLister;
    }
}

