/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.cli;

import de.gwdg.metadataqa.marc.cli.parameters.FormatterParameters;
import de.gwdg.metadataqa.marc.cli.processor.BibliographicInputProcessor;
import de.gwdg.metadataqa.marc.cli.utils.RecordIterator;
import de.gwdg.metadataqa.marc.dao.DataField;
import de.gwdg.metadataqa.marc.dao.record.BibliographicRecord;
import de.gwdg.metadataqa.marc.definition.bibliographic.SchemaType;
import de.gwdg.metadataqa.marc.utils.SchemaSpec;
import de.gwdg.metadataqa.marc.utils.marcspec.legacy.MarcSpec;
import de.gwdg.metadataqa.marc.utils.pica.path.PicaSpec;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.marc4j.marc.Record;

public class Formatter
implements BibliographicInputProcessor {
    private static final Logger logger = Logger.getLogger(Formatter.class.getCanonicalName());
    private FormatterParameters parameters;
    private boolean readyToProcess;
    private BufferedWriter writer;

    public Formatter(String[] args2) throws ParseException {
        this.parameters = new FormatterParameters(args2);
        this.readyToProcess = true;
    }

    public static void main(String[] args2) throws ParseException {
        System.err.println("'" + StringUtils.join((Object[])args2, "', '") + "'");
        Formatter processor = new Formatter(args2);
        if (processor.getParameters().getArgs().length < 1) {
            System.err.println("Please provide a MARC file name!");
            System.exit(0);
        }
        if (processor.getParameters().doHelp()) {
            processor.printHelp(processor.getParameters().getOptions());
            System.exit(0);
        }
        RecordIterator iterator2 = new RecordIterator(processor);
        logger.info(processor.getParameters().formatParameters());
        iterator2.start();
    }

    @Override
    public void printHelp(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        String message = String.format("java -cp qa-catalogue.jar %s [options] [file]", this.getClass().getCanonicalName());
        formatter.printHelp(message, options);
    }

    @Override
    public FormatterParameters getParameters() {
        return this.parameters;
    }

    @Override
    public void beforeIteration() {
        logger.info(this.parameters.formatParameters());
        if (this.parameters.hasSelector()) {
            Path path = Paths.get(this.parameters.getOutputDir(), this.parameters.getFileName());
            try {
                this.writer = Files.newBufferedWriter(path, new OpenOption[0]);
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "beforeIteration", e);
            }
            ArrayList<String> values2 = new ArrayList<String>();
            if (this.parameters.withId()) {
                values2.add("id");
            }
            for (SchemaSpec spec : this.parameters.getSelector()) {
                values2.add(spec.encode());
            }
            try {
                this.writer.write(StringUtils.join(values2, this.parameters.getSeparator()) + "\n");
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "beforeIteration", e);
            }
        }
    }

    @Override
    public void fileOpened(Path file) {
    }

    @Override
    public void processRecord(Record marc4jRecord, int recordNumber) throws IOException {
        if (this.parameters.hasId() && marc4jRecord.getControlNumber() != null && marc4jRecord.getControlNumber().trim().equals(this.parameters.getId()) || this.parameters.getCountNr() > -1 && this.parameters.getCountNr() == recordNumber) {
            System.out.println(marc4jRecord.toString());
        }
    }

    @Override
    public void processRecord(BibliographicRecord marcRecord, int recordNumber) throws IOException {
        List<String> results;
        if (this.parameters.hasId() && marcRecord.getId().trim().equals(this.parameters.getId())) {
            for (DataField dataField : marcRecord.getDatafields()) {
                System.err.println(dataField.getTag());
            }
            System.err.println("has STA: " + marcRecord.hasDatafield("STA"));
        }
        if (this.parameters.hasSearch() && !(results = marcRecord.search(this.parameters.getPath(), this.parameters.getQuery())).isEmpty()) {
            System.out.println(marcRecord.toString());
        }
        if (this.parameters.hasSelector()) {
            ArrayList<String> values2 = new ArrayList<String>();
            if (this.parameters.withId()) {
                values2.add(marcRecord.getId());
            }
            if (this.parameters.getSchemaType().equals((Object)SchemaType.MARC21)) {
                for (SchemaSpec marcSpec : this.parameters.getSelector()) {
                    List<String> results2 = marcRecord.select((MarcSpec)marcSpec);
                    values2.add(results2.isEmpty() ? "" : StringUtils.join(results2, "||"));
                }
            } else if (this.parameters.getSchemaType().equals((Object)SchemaType.PICA)) {
                for (SchemaSpec marcSpec : this.parameters.getSelector()) {
                    PicaSpec spec = (PicaSpec)marcSpec;
                    List<String> results3 = marcRecord.select(spec.getPath());
                    if (!results3.isEmpty() && spec.getFunction() != null) {
                        ArrayList<String> candidates = new ArrayList<String>();
                        for (String result2 : results3) {
                            if (!spec.getFunction().equals("extractPicaDate")) continue;
                            candidates.add(Formatter.extractPicaDate(result2));
                        }
                        results3 = candidates;
                    }
                    values2.add(results3.isEmpty() ? "" : StringUtils.join(results3, "||"));
                }
            }
            try {
                this.writer.write(StringUtils.join(values2, this.parameters.getSeparator()) + "\n");
            }
            catch (IOException iOException) {
                logger.log(Level.SEVERE, "processRecord", iOException);
            }
        }
    }

    @Override
    public void fileProcessed() {
    }

    @Override
    public void afterIteration(int numberOfprocessedRecords) {
        if (this.writer != null) {
            try {
                this.writer.close();
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "afterIteration", e);
            }
        }
    }

    @Override
    public boolean readyToProcess() {
        return this.readyToProcess;
    }

    public static String extractPicaDate(String dateInString) {
        String[] parts1 = dateInString.split(":", 2);
        String[] dateParts = parts1[1].split("-");
        return dateParts[2] + dateParts[1] + dateParts[0];
    }
}

