/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.cli;

import de.gwdg.metadataqa.marc.CsvUtils;
import de.gwdg.metadataqa.marc.Utils;
import de.gwdg.metadataqa.marc.analysis.GroupSelector;
import de.gwdg.metadataqa.marc.analysis.completeness.CompletenessDAO;
import de.gwdg.metadataqa.marc.analysis.completeness.RecordCompleteness;
import de.gwdg.metadataqa.marc.cli.QACli;
import de.gwdg.metadataqa.marc.cli.parameters.CommonParameters;
import de.gwdg.metadataqa.marc.cli.parameters.CompletenessParameters;
import de.gwdg.metadataqa.marc.cli.plugin.CompletenessFactory;
import de.gwdg.metadataqa.marc.cli.plugin.CompletenessPlugin;
import de.gwdg.metadataqa.marc.cli.processor.BibliographicInputProcessor;
import de.gwdg.metadataqa.marc.cli.utils.RecordIterator;
import de.gwdg.metadataqa.marc.cli.utils.ignorablerecords.RecordFilter;
import de.gwdg.metadataqa.marc.cli.utils.ignorablerecords.RecordIgnorator;
import de.gwdg.metadataqa.marc.dao.record.BibliographicRecord;
import de.gwdg.metadataqa.marc.definition.tags.TagCategory;
import de.gwdg.metadataqa.marc.model.validation.ValidationErrorFormat;
import de.gwdg.metadataqa.marc.utils.BasicStatistics;
import de.gwdg.metadataqa.marc.utils.TagHierarchy;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.marc4j.marc.Record;

public class Completeness
extends QACli
implements BibliographicInputProcessor,
Serializable {
    private static final Logger logger = Logger.getLogger(Completeness.class.getCanonicalName());
    private static final Pattern dataFieldPattern = Pattern.compile("^(\\d\\d\\d)\\$(.*)$");
    public static final String ALL_TYPE = "all";
    private CompletenessParameters parameters;
    private CompletenessDAO completenessDAO = new CompletenessDAO();
    private boolean readyToProcess;
    private CompletenessPlugin plugin;
    private RecordFilter recordFilter;
    private RecordIgnorator recordIgnorator;

    public Completeness(String[] args2) throws ParseException {
        this.parameters = new CompletenessParameters(args2);
        this.plugin = CompletenessFactory.create(this.parameters);
        this.recordFilter = this.parameters.getRecordFilter();
        this.recordIgnorator = this.parameters.getRecordIgnorator();
        this.readyToProcess = true;
        this.initializeGroups(this.parameters.getGroupBy(), this.parameters.isPica());
        if (this.doGroups()) {
            this.initializeMeta(this.parameters);
            if (this.doSaveGroupIds) {
                this.idCollectorFile = this.prepareReportFile(this.parameters.getOutputDir(), "id-groupid.csv");
                this.printToFile(this.idCollectorFile, CsvUtils.createCsv("id", "groupId"));
            }
        }
    }

    public static void main(String[] args2) {
        Completeness processor = null;
        try {
            processor = new Completeness(args2);
        }
        catch (ParseException e) {
            System.err.println("ERROR. " + e.getLocalizedMessage());
            System.exit(0);
        }
        if (processor.getParameters().getArgs().length < 1) {
            System.err.println("Please provide a MARC file name!");
            processor.printHelp(processor.getParameters().getOptions());
            System.exit(0);
        }
        if (processor.getParameters().doHelp()) {
            processor.printHelp(processor.getParameters().getOptions());
            System.exit(0);
        }
        RecordIterator iterator2 = new RecordIterator(processor);
        iterator2.start();
    }

    @Override
    public CommonParameters getParameters() {
        return this.parameters;
    }

    @Override
    public void processRecord(Record marc4jRecord, int recordNumber) throws IOException {
    }

    @Override
    public void processRecord(BibliographicRecord bibliographicRecord, int recordNumber) throws IOException {
        if (!this.recordFilter.isAllowable(bibliographicRecord)) {
            return;
        }
        if (this.recordIgnorator.isIgnorable(bibliographicRecord)) {
            return;
        }
        RecordCompleteness recordCompleteness = new RecordCompleteness(bibliographicRecord, this.parameters, this.completenessDAO, this.plugin, this.groupBy);
        recordCompleteness.process();
        if (this.doSaveGroupIds) {
            this.saveGroupIds(bibliographicRecord.getId(true), recordCompleteness.getGroupIds());
        }
        if (this.doGroups()) {
            for (String id : recordCompleteness.getGroupIds()) {
                Utils.count(id, this.completenessDAO.getGroupCounter());
            }
        }
        for (String path : recordCompleteness.getRecordFrequency().keySet()) {
            if (this.groupBy != null) {
                for (String groupId : recordCompleteness.getGroupIds()) {
                    this.completenessDAO.getGroupedElementFrequency().computeIfAbsent(groupId, s -> new HashMap());
                    this.completenessDAO.getGroupedElementFrequency().get(groupId).computeIfAbsent(recordCompleteness.getDocumentType(), s -> new HashMap());
                    this.completenessDAO.getGroupedElementFrequency().get(groupId).computeIfAbsent(ALL_TYPE, s -> new HashMap());
                    Utils.count(path, this.completenessDAO.getGroupedElementFrequency().get(groupId).get(recordCompleteness.getDocumentType()));
                    Utils.count(path, this.completenessDAO.getGroupedElementFrequency().get(groupId).get(ALL_TYPE));
                    this.completenessDAO.getGroupedFieldHistogram().computeIfAbsent(groupId, s -> new HashMap());
                    this.completenessDAO.getGroupedFieldHistogram().get(groupId).computeIfAbsent(path, s -> new HashMap());
                    Utils.count(recordCompleteness.getRecordFrequency().get(path), this.completenessDAO.getGroupedFieldHistogram().get(groupId).get(path));
                }
                continue;
            }
            Utils.count(path, this.completenessDAO.getElementFrequency().get(recordCompleteness.getDocumentType()));
            Utils.count(path, this.completenessDAO.getElementFrequency().get(ALL_TYPE));
            this.completenessDAO.getFieldHistogram().computeIfAbsent(path, s -> new HashMap());
            Utils.count(recordCompleteness.getRecordFrequency().get(path), this.completenessDAO.getFieldHistogram().get(path));
        }
        for (String key : recordCompleteness.getRecordPackageCounter().keySet()) {
            if (this.groupBy != null) {
                for (String groupId : recordCompleteness.getGroupIds()) {
                    this.completenessDAO.getGroupedPackageCounter().computeIfAbsent(groupId, s -> new HashMap());
                    this.completenessDAO.getGroupedPackageCounter().get(groupId).computeIfAbsent(recordCompleteness.getDocumentType(), s -> new HashMap());
                    this.completenessDAO.getGroupedPackageCounter().get(groupId).computeIfAbsent(ALL_TYPE, s -> new HashMap());
                    Utils.count(key, this.completenessDAO.getGroupedPackageCounter().get(groupId).get(recordCompleteness.getDocumentType()));
                    Utils.count(key, this.completenessDAO.getGroupedPackageCounter().get(groupId).get(ALL_TYPE));
                }
                continue;
            }
            this.completenessDAO.getPackageCounter().computeIfAbsent(recordCompleteness.getDocumentType(), s -> new HashMap());
            this.completenessDAO.getPackageCounter().computeIfAbsent(ALL_TYPE, s -> new HashMap());
            Utils.count(key, this.completenessDAO.getPackageCounter().get(recordCompleteness.getDocumentType()));
            Utils.count(key, this.completenessDAO.getPackageCounter().get(ALL_TYPE));
        }
    }

    @Override
    public void beforeIteration() {
        logger.info(this.parameters.formatParameters());
        this.completenessDAO.initialize();
        this.saveParameters("completeness.params.json", this.parameters);
    }

    @Override
    public void fileOpened(Path file) {
    }

    @Override
    public void fileProcessed() {
    }

    @Override
    public void afterIteration(int numberOfprocessedRecords) {
        String fileExtension = ".csv";
        char separator = this.getSeparator(this.parameters.getFormat());
        if (this.parameters.getFormat().equals((Object)ValidationErrorFormat.TAB_SEPARATED)) {
            fileExtension = ".tsv";
        }
        this.saveLibraries003(fileExtension, separator);
        this.saveLibraries(fileExtension, separator);
        if (this.groupBy != null) {
            this.saveGroups(fileExtension, separator);
            this.saveGroupedPackages(fileExtension, separator);
            this.saveGroupedMarcElements(fileExtension, separator);
        } else {
            this.savePackages(fileExtension, separator);
            this.saveMarcElements(fileExtension, separator);
        }
    }

    private void saveLibraries003(String fileExtension, char separator) {
        logger.info("Saving libraries003...");
        Path path = Paths.get(this.parameters.getOutputDir(), "libraries003" + fileExtension);
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            writer.write(CsvUtils.createCsv("library", "count"));
            this.completenessDAO.getLibrary003Counter().forEach((key, value) -> {
                try {
                    writer.write(CsvUtils.createCsv(key, value));
                }
                catch (IOException e) {
                    logger.log(Level.SEVERE, "saveLibraries003", e);
                }
            });
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "saveLibraries003", e);
        }
    }

    private void saveMarcElements(String fileExtension, char separator) {
        Path path = Paths.get(this.parameters.getOutputDir(), "marc-elements" + fileExtension);
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            writer.write(CsvUtils.createCsv("groupId", "documenttype", "path", "sortkey", "packageid", "package", "tag", "subfield", "number-of-record", "number-of-instances", "min", "max", "mean", "stddev", "histogram"));
            this.completenessDAO.getElementCardinality().forEach((documentType, cardinalities) -> cardinalities.forEach((marcPath, cardinality) -> {
                try {
                    writer.write(this.formatCardinality((String)marcPath, (int)cardinality, (String)documentType, null));
                }
                catch (IOException e) {
                    logger.log(Level.SEVERE, "saveMarcElements", e);
                }
            }));
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "saveMarcElements", e);
        }
    }

    private void saveGroupedMarcElements(String fileExtension, char separator) {
        logger.info("saving grouped MARC elements...");
        Path path = Paths.get(this.parameters.getOutputDir(), "completeness-grouped-marc-elements" + fileExtension);
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            writer.write(CsvUtils.createCsv("groupId", "documenttype", "path", "sortkey", "packageid", "package", "tag", "subfield", "number-of-record", "number-of-instances", "min", "max", "mean", "stddev", "histogram"));
            this.completenessDAO.getGroupedElementCardinality().forEach((groupId, documentTypes) -> documentTypes.forEach((documentType, cardinalities) -> cardinalities.forEach((marcPath, cardinality) -> {
                try {
                    writer.write(this.formatCardinality((String)marcPath, (int)cardinality, (String)documentType, (String)groupId));
                }
                catch (IOException e) {
                    logger.log(Level.SEVERE, "saveMarcElements", e);
                }
            })));
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "saveMarcElements", e);
        }
    }

    private void savePackages(String fileExtension, char separator) {
        logger.info("saving packages...");
        Path path = Paths.get(this.parameters.getOutputDir(), "packages" + fileExtension);
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            writer.write(CsvUtils.createCsv("documenttype", "packageid", "name", "label", "iscoretag", "count"));
            this.completenessDAO.getPackageCounter().forEach((documentType, packages2) -> packages2.forEach((packageName, count) -> {
                try {
                    TagCategory tagCategory = TagCategory.getPackage(packageName);
                    String range = packageName;
                    String label = "";
                    int id = 100;
                    boolean isPartOfMarcScore = false;
                    if (tagCategory != null) {
                        id = tagCategory.getId();
                        range = tagCategory.getRange();
                        label = tagCategory.getLabel();
                        isPartOfMarcScore = tagCategory.isPartOfMarcCore();
                    } else {
                        logger.severe(packageName + " has not been found in TagCategory");
                    }
                    writer.write(CsvUtils.createCsv(documentType, id, range, label, isPartOfMarcScore, count));
                }
                catch (IOException e) {
                    logger.log(Level.SEVERE, "savePackages", e);
                }
            }));
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "savePackages", e);
        }
    }

    private void saveGroupedPackages(String fileExtension, char separator) {
        logger.info("saving grouped packages...");
        Path path = Paths.get(this.parameters.getOutputDir(), "completeness-grouped-packages" + fileExtension);
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            writer.write(CsvUtils.createCsv("group", "documenttype", "packageid", "name", "label", "iscoretag", "count"));
            this.completenessDAO.getGroupedPackageCounter().entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(groupData -> {
                String groupId = (String)groupData.getKey();
                Map documentTypes = (Map)groupData.getValue();
                documentTypes.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(doctypeData -> {
                    String documentType = (String)doctypeData.getKey();
                    Map packages2 = (Map)doctypeData.getValue();
                    packages2.forEach((packageName, count) -> {
                        try {
                            TagCategory tagCategory = TagCategory.getPackage(packageName);
                            String range = packageName;
                            String label = "";
                            int id = 100;
                            boolean isPartOfMarcScore = false;
                            if (tagCategory != null) {
                                id = tagCategory.getId();
                                range = tagCategory.getRange();
                                label = tagCategory.getLabel();
                                isPartOfMarcScore = tagCategory.isPartOfMarcCore();
                            } else {
                                logger.severe(packageName + " has not been found in TagCategory");
                            }
                            writer.write(CsvUtils.createCsv(groupId, documentType, id, range, label, isPartOfMarcScore, count));
                        }
                        catch (IOException e) {
                            logger.log(Level.SEVERE, "savePackages", e);
                        }
                    });
                });
            });
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "savePackages", e);
        }
    }

    private void saveLibraries(String fileExtension, char separator) {
        logger.info("Saving libraries...");
        Path path = Paths.get(this.parameters.getOutputDir(), "libraries" + fileExtension);
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            writer.write(CsvUtils.createCsv("library", "count"));
            this.completenessDAO.getLibraryCounter().forEach((key, value) -> {
                try {
                    writer.write(CsvUtils.createCsv(key, value));
                }
                catch (IOException e) {
                    logger.log(Level.SEVERE, "saveLibraries", e);
                }
            });
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "saveLibraries", e);
        }
    }

    private void saveGroups(String fileExtension, char separator) {
        logger.info("Saving groups...");
        GroupSelector groupSelector = new GroupSelector(this.parameters.getGroupListFile());
        Path path = Paths.get(this.parameters.getOutputDir(), "completeness-groups" + fileExtension);
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            writer.write(CsvUtils.createCsv("id", "group", "count"));
            this.completenessDAO.getGroupCounter().entrySet().stream().sorted((a, b) -> ((String)a.getKey()).compareTo((String)b.getKey())).forEach(item -> {
                try {
                    writer.write(CsvUtils.createCsv(item.getKey(), groupSelector.getOrgName((String)item.getKey()), item.getValue()));
                }
                catch (IOException e) {
                    logger.log(Level.SEVERE, "saveLibraries", e);
                }
            });
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "saveLibraries", e);
        }
    }

    private String formatCardinality(String marcPath, int cardinality, String documentType, String groupId) {
        if (marcPath.equals("")) {
            logger.severe("Empty key from " + marcPath);
        }
        String marcPathLabel = marcPath.replace("!ind", "ind").replaceAll("\\|(\\d)$", "$1");
        String sortkey = marcPath.replaceAll("^leader", "000");
        int packageId = TagCategory.OTHER.getId();
        String packageLabel = TagCategory.OTHER.getLabel();
        String tagLabel = "";
        String subfieldLabel = "";
        TagHierarchy tagHierarchy = this.plugin.getTagHierarchy(marcPathLabel);
        if (tagHierarchy != null) {
            packageId = tagHierarchy.getPackageId();
            packageLabel = tagHierarchy.getPackageLabel();
            tagLabel = tagHierarchy.getTagLabel();
            subfieldLabel = tagHierarchy.getSubfieldLabel();
        } else {
            logger.severe("Key can not be found in the TagHierarchy: " + marcPathLabel);
        }
        Integer frequency = groupId != null ? this.completenessDAO.getGroupedElementFrequency().get(groupId).get(documentType).get(marcPath) : this.completenessDAO.getElementFrequency().get(documentType).get(marcPath);
        Map<Integer, Integer> histogram = null;
        if (groupId != null) {
            histogram = this.completenessDAO.getGroupedFieldHistogram().get(groupId).get(marcPath);
            if (!this.completenessDAO.getGroupedFieldHistogram().get(groupId).containsKey(marcPath)) {
                logger.log(Level.WARNING, "Field {0} is not registered in histogram", marcPath);
            }
        } else {
            histogram = this.completenessDAO.getFieldHistogram().get(marcPath);
            if (!this.completenessDAO.getFieldHistogram().containsKey(marcPath)) {
                logger.log(Level.WARNING, "Field {0} is not registered in histogram", marcPath);
            }
        }
        BasicStatistics statistics = new BasicStatistics(histogram);
        List<Object> values2 = Arrays.asList(groupId != null ? groupId : Integer.valueOf(0), documentType, marcPathLabel, sortkey, packageId, packageLabel, tagLabel, subfieldLabel, frequency, cardinality, statistics.getMin(), statistics.getMax(), statistics.getMean(), statistics.getStdDev(), statistics.formatHistogram());
        return CsvUtils.createCsvFromObjects(values2);
    }

    private char getSeparator(ValidationErrorFormat format) {
        if (format.equals((Object)ValidationErrorFormat.TAB_SEPARATED)) {
            return '\t';
        }
        return ',';
    }

    @Override
    public void printHelp(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        String message = String.format("java -cp qa-catalogue.jar %s [options] [file]", this.getClass().getCanonicalName());
        formatter.printHelp(message, options);
    }

    @Override
    public boolean readyToProcess() {
        return this.readyToProcess;
    }
}

