/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.analysis.validator;

import de.gwdg.metadataqa.marc.MarcSubfield;
import de.gwdg.metadataqa.marc.analysis.validator.AbstractValidator;
import de.gwdg.metadataqa.marc.analysis.validator.ValidatorConfiguration;
import de.gwdg.metadataqa.marc.definition.ValidatorResponse;
import de.gwdg.metadataqa.marc.definition.general.parser.ParserException;
import de.gwdg.metadataqa.marc.definition.general.parser.SubfieldContentParser;
import de.gwdg.metadataqa.marc.definition.structure.SubfieldDefinition;
import de.gwdg.metadataqa.marc.model.validation.ErrorsCollector;
import de.gwdg.metadataqa.marc.model.validation.ValidationErrorType;
import java.util.ArrayList;

public class SubfieldValidator
extends AbstractValidator {
    private ErrorsCollector errors;
    private SubfieldDefinition definition;
    private MarcSubfield subfield;

    public SubfieldValidator() {
        super(new ValidatorConfiguration());
    }

    public SubfieldValidator(ValidatorConfiguration configuration) {
        super(configuration);
    }

    public boolean validate(MarcSubfield subfield) {
        this.errors = new ErrorsCollector();
        this.validationErrors = new ArrayList();
        this.subfield = subfield;
        this.definition = subfield.getDefinition();
        if (this.definition == null) {
            this.addError(subfield.getField().getDefinition().getTag(), ValidationErrorType.SUBFIELD_UNDEFINED, subfield.getCode());
            return false;
        }
        if (subfield.getCode() == null) {
            this.addError(subfield.getField().getDefinition().getTag(), ValidationErrorType.SUBFIELD_NULL_CODE, subfield.getCode());
        } else if (this.definition.isDisallowedIn(this.configuration.getMarcVersion())) {
            this.addError(subfield.getField().getDefinition().getTag(), ValidationErrorType.SUBFIELD_UNDEFINED, subfield.getCode());
        } else if (this.definition.hasValidator()) {
            this.validateWithValidator();
        } else if (this.definition.hasContentParser()) {
            this.validateWithParser();
        } else if (this.definition.getCodes() != null && this.definition.getCode(subfield.getValue()) == null) {
            Object message = subfield.getValue();
            if (subfield.getReferencePath() != null) {
                message = (String)message + String.format(" (the field is embedded in %s)", subfield.getReferencePath());
            }
            String path = subfield.getReferencePath() == null ? this.definition.getPath() : subfield.getReferencePath() + "->" + this.definition.getPath();
            this.addError(path, ValidationErrorType.SUBFIELD_INVALID_VALUE, (String)message);
        }
        this.validationErrors.addAll(this.errors.getErrors());
        return this.errors.isEmpty();
    }

    private boolean validateWithValidator() {
        boolean isValid = true;
        de.gwdg.metadataqa.marc.definition.general.validator.SubfieldValidator validator = this.definition.getValidator();
        ValidatorResponse response = validator.isValid(this.subfield);
        if (!response.isValid()) {
            this.errors.addAll(response.getValidationErrors());
            isValid = false;
        }
        return isValid;
    }

    private boolean validateWithParser() {
        boolean isValid = true;
        SubfieldContentParser parser = this.definition.getContentParser();
        try {
            parser.parse(this.subfield.getValue());
        }
        catch (ParserException e) {
            this.addError(ValidationErrorType.SUBFIELD_UNPARSABLE_CONTENT, e.getMessage());
            isValid = false;
        }
        return isValid;
    }

    private void addError(ValidationErrorType type2, String message) {
        this.addError(this.definition.getPath(), type2, message);
    }

    private void addError(String path, ValidationErrorType type2, String message) {
        if (!this.isIgnorableType(type2)) {
            String id = this.subfield.getMarcRecord() == null ? null : this.subfield.getMarcRecord().getId();
            String url = this.definition.getParent().getDescriptionUrl();
            this.errors.add(id, path, type2, message, url);
        }
    }
}

