/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.analysis.validator;

import de.gwdg.metadataqa.marc.analysis.validator.AbstractValidator;
import de.gwdg.metadataqa.marc.analysis.validator.ControlValueValidator;
import de.gwdg.metadataqa.marc.analysis.validator.ValidatorConfiguration;
import de.gwdg.metadataqa.marc.dao.Control005;
import de.gwdg.metadataqa.marc.dao.MarcControlField;
import de.gwdg.metadataqa.marc.dao.MarcPositionalControlField;
import de.gwdg.metadataqa.marc.dao.SimpleControlField;
import de.gwdg.metadataqa.marc.definition.ControlValue;
import java.util.ArrayList;

public class ControlFieldValidator
extends AbstractValidator {
    public ControlFieldValidator() {
        super(new ValidatorConfiguration());
    }

    public ControlFieldValidator(ValidatorConfiguration configuration) {
        super(configuration);
    }

    public boolean validate(MarcControlField controlField) {
        this.validationErrors = new ArrayList();
        if (controlField instanceof SimpleControlField) {
            return this.validateSimpleControlField((SimpleControlField)controlField);
        }
        if (controlField instanceof MarcPositionalControlField) {
            return this.validateMarcPositionalControlField((MarcPositionalControlField)controlField);
        }
        return this.validationErrors.isEmpty();
    }

    private boolean validateMarcPositionalControlField(MarcPositionalControlField controlField) {
        if (!controlField.getInitializationErrors().isEmpty()) {
            this.validationErrors.addAll(this.filterErrors(controlField.getInitializationErrors()));
        }
        ControlValueValidator validator = new ControlValueValidator(this.configuration);
        for (ControlValue controlValue : controlField.getValuesList()) {
            if (validator.validate(controlValue)) continue;
            this.validationErrors.addAll(validator.getValidationErrors());
        }
        return this.validationErrors.isEmpty();
    }

    private boolean validateSimpleControlField(SimpleControlField controlField) {
        if (controlField instanceof Control005) {
            Control005 control = (Control005)controlField;
            control.validate(this.configuration.getMarcVersion());
            this.validationErrors.addAll(this.filterErrors(control.getValidationErrors()));
        }
        return this.validationErrors.isEmpty();
    }
}

