/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.analysis.validator;

import de.gwdg.metadataqa.marc.analysis.validator.ValidatorConfiguration;
import de.gwdg.metadataqa.marc.model.validation.ValidationError;
import de.gwdg.metadataqa.marc.model.validation.ValidationErrorType;
import java.util.List;
import java.util.stream.Collectors;

public abstract class AbstractValidator {
    final ValidatorConfiguration configuration;
    List<ValidationError> validationErrors = null;

    protected AbstractValidator(ValidatorConfiguration configuration) {
        this.configuration = configuration;
    }

    protected List<ValidationError> filterErrors(List<ValidationError> errors) {
        if (this.configuration.getIgnorableIssueTypes() == null || this.configuration.getIgnorableIssueTypes().isEmpty()) {
            return errors;
        }
        return errors.stream().filter(error -> !this.configuration.getIgnorableIssueTypes().contains((Object)error.getType())).collect(Collectors.toList());
    }

    public List<ValidationError> getValidationErrors() {
        return this.validationErrors;
    }

    protected boolean isIgnorableType(ValidationErrorType type2) {
        return this.configuration.getIgnorableIssueTypes() != null && !this.configuration.getIgnorableIssueTypes().isEmpty() && this.configuration.getIgnorableIssueTypes().contains((Object)type2);
    }
}

