/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.analysis.completeness;

import de.gwdg.metadataqa.marc.MarcSubfield;
import de.gwdg.metadataqa.marc.Utils;
import de.gwdg.metadataqa.marc.analysis.completeness.CompletenessDAO;
import de.gwdg.metadataqa.marc.cli.QACli;
import de.gwdg.metadataqa.marc.cli.parameters.CompletenessParameters;
import de.gwdg.metadataqa.marc.cli.plugin.CompletenessPlugin;
import de.gwdg.metadataqa.marc.dao.DataField;
import de.gwdg.metadataqa.marc.dao.MarcControlField;
import de.gwdg.metadataqa.marc.dao.MarcPositionalControlField;
import de.gwdg.metadataqa.marc.dao.record.BibliographicRecord;
import de.gwdg.metadataqa.marc.definition.ControlValue;
import de.gwdg.metadataqa.marc.definition.tags.TagCategory;
import de.gwdg.metadataqa.marc.utils.BibiographicPath;
import de.gwdg.metadataqa.marc.utils.pica.path.PicaPath;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class RecordCompleteness {
    private static final Logger logger = Logger.getLogger(RecordCompleteness.class.getCanonicalName());
    private static final Pattern numericalPattern = Pattern.compile("^(\\d)$");
    public static final String IND_1 = "$!ind1";
    public static final String IND_2 = "$!ind2";
    public static final String NUMERICAL_SUBFIELD = "$|";
    public static final String SUBFIELD = "$";
    private static Map<String, Map<String, String>> keyMap = new HashMap<String, Map<String, String>>();
    private final BibiographicPath groupBy;
    private final CompletenessParameters parameters;
    private final CompletenessDAO completenessDAO;
    private final CompletenessPlugin plugin;
    BibliographicRecord bibliographicRecord;
    String documentType;
    boolean hasGroupBy;
    Map<String, Integer> recordFrequency = new HashMap<String, Integer>();
    Map<String, Integer> recordPackageCounter = new HashMap<String, Integer>();
    Set<String> groupIds = new HashSet<String>();

    public RecordCompleteness(BibliographicRecord bibliographicRecord, CompletenessParameters parameters2, CompletenessDAO completenessDAO, CompletenessPlugin plugin, BibiographicPath groupBy) {
        this.bibliographicRecord = bibliographicRecord;
        this.parameters = parameters2;
        this.completenessDAO = completenessDAO;
        this.plugin = plugin;
        this.groupBy = groupBy;
        boolean bl = this.hasGroupBy = groupBy != null;
        if (this.hasGroupBy) {
            List<String> idLists = parameters2.isPica() ? bibliographicRecord.select((PicaPath)groupBy) : null;
            this.groupIds = QACli.extractGroupIds(idLists);
        }
    }

    public void process() {
        this.documentType = this.plugin.getDocumentType(this.bibliographicRecord);
        this.completenessDAO.getElementCardinality().computeIfAbsent(this.documentType, s -> new HashMap());
        this.completenessDAO.getElementCardinality().computeIfAbsent("all", s -> new HashMap());
        this.completenessDAO.getElementFrequency().computeIfAbsent(this.documentType, s -> new HashMap());
        this.completenessDAO.getElementFrequency().computeIfAbsent("all", s -> new HashMap());
        if (this.bibliographicRecord.getControl003() != null) {
            Utils.count(this.bibliographicRecord.getControl003().getContent(), this.completenessDAO.getLibrary003Counter());
        }
        for (String library : this.extract(this.bibliographicRecord, "852", "a")) {
            Utils.count(library, this.completenessDAO.getLibraryCounter());
        }
        if (!this.parameters.isPica()) {
            this.processLeader();
            this.processSimpleControlfields();
            this.processPositionalControlFields();
        }
        this.processDataFields();
    }

    private void processLeader() {
        if (this.bibliographicRecord.getLeader() != null) {
            for (ControlValue position : this.bibliographicRecord.getLeader().getValuesList()) {
                String marcPath = position.getDefinition().getId();
                if (this.hasGroupBy()) {
                    for (String groupId : this.groupIds) {
                        this.addGroupedElementCardinality(marcPath, groupId);
                    }
                } else {
                    Utils.count(marcPath, this.completenessDAO.getElementCardinality().get(this.documentType));
                    Utils.count(marcPath, this.completenessDAO.getElementCardinality().get("all"));
                }
                Utils.count(marcPath, this.recordFrequency);
                Utils.count(TagCategory.TAGS_00X.getPackageName(), this.recordPackageCounter);
            }
        }
    }

    private void processSimpleControlfields() {
        for (MarcControlField field : this.bibliographicRecord.getSimpleControlfields()) {
            if (field == null) continue;
            String marcPath = field.getDefinition().getTag();
            if (this.hasGroupBy()) {
                for (String groupId : this.groupIds) {
                    this.addGroupedElementCardinality(marcPath, groupId);
                }
            } else {
                Utils.count(marcPath, this.completenessDAO.getElementCardinality().get(this.documentType));
                Utils.count(marcPath, this.completenessDAO.getElementCardinality().get("all"));
            }
            Utils.count(marcPath, this.recordFrequency);
            Utils.count(TagCategory.TAGS_00X.getPackageName(), this.recordPackageCounter);
        }
    }

    private void processPositionalControlFields() {
        for (MarcPositionalControlField field : this.bibliographicRecord.getPositionalControlfields()) {
            if (field == null) continue;
            for (ControlValue position : field.getValuesList()) {
                String marcPath = position.getDefinition().getId();
                if (this.hasGroupBy()) {
                    for (String groupId : this.groupIds) {
                        this.addGroupedElementCardinality(marcPath, groupId);
                    }
                } else {
                    Utils.count(marcPath, this.completenessDAO.getElementCardinality().get(this.documentType));
                    Utils.count(marcPath, this.completenessDAO.getElementCardinality().get("all"));
                }
                Utils.count(marcPath, this.recordFrequency);
                Utils.count(TagCategory.TAGS_00X.getPackageName(), this.recordPackageCounter);
            }
        }
    }

    private void processDataFields() {
        for (DataField field : this.bibliographicRecord.getDatafields()) {
            if (this.parameters.getIgnorableFields().contains(field.getTagWithOccurrence())) continue;
            Utils.count(this.getPackageName(field), this.recordPackageCounter);
            Utils.count(field.getTagWithOccurrence(), this.recordFrequency);
            for (String marcPath : this.getMarcPaths(field)) {
                Utils.count(marcPath, this.recordFrequency);
            }
            if (this.groupBy != null) {
                for (String groupId : this.groupIds) {
                    this.processGroupedDataField(field, groupId);
                }
                continue;
            }
            this.processDataField(field);
        }
    }

    private void processDataField(DataField field) {
        Utils.count(field.getTagWithOccurrence(), this.completenessDAO.getElementCardinality().get(this.documentType));
        Utils.count(field.getTagWithOccurrence(), this.completenessDAO.getElementCardinality().get("all"));
        List<String> marcPaths = this.getMarcPaths(field);
        for (String marcPath : marcPaths) {
            Utils.count(marcPath, this.completenessDAO.getElementCardinality().get(this.documentType));
            Utils.count(marcPath, this.completenessDAO.getElementCardinality().get("all"));
        }
    }

    private void processGroupedDataField(DataField field, String groupId) {
        this.addGroupedElementCardinality(field.getTagWithOccurrence(), groupId);
        List<String> marcPaths = this.getMarcPaths(field);
        for (String marcPath : marcPaths) {
            Utils.count(marcPath, this.completenessDAO.getGroupedElementCardinality().get(groupId).get(this.documentType));
            Utils.count(marcPath, this.completenessDAO.getGroupedElementCardinality().get(groupId).get("all"));
        }
    }

    public Set<String> getGroupIds() {
        return this.groupIds;
    }

    public Map<String, Integer> getRecordFrequency() {
        return this.recordFrequency;
    }

    public Map<String, Integer> getRecordPackageCounter() {
        return this.recordPackageCounter;
    }

    public String getDocumentType() {
        return this.documentType;
    }

    public boolean hasGroupBy() {
        return this.hasGroupBy;
    }

    private List<String> extract(BibliographicRecord marcRecord, String tag, String subfield) {
        ArrayList<String> values2 = new ArrayList<String>();
        List<DataField> fields2 = marcRecord.getDatafield(tag);
        if (fields2 != null && !fields2.isEmpty()) {
            for (DataField field : fields2) {
                List<MarcSubfield> subfieldInstances = field.getSubfield(subfield);
                if (subfieldInstances == null) continue;
                for (MarcSubfield subfieldInstance : subfieldInstances) {
                    values2.add(subfieldInstance.getValue());
                }
            }
        }
        return values2;
    }

    private String getPackageName(DataField field) {
        String packageName;
        if (field.getDefinition() != null) {
            if (this.completenessDAO.getPackageNameCache().containsKey(field.getDefinition())) {
                packageName = this.completenessDAO.getPackageNameCache().get(field.getDefinition());
            } else {
                packageName = this.plugin.getPackageName(field);
                if (StringUtils.isBlank(packageName)) {
                    logger.log(Level.WARNING, "{0} has no package. /{1}", new Object[]{field, field.getDefinition().getClass()});
                    packageName = TagCategory.OTHER.getPackageName();
                }
                this.completenessDAO.getPackageNameCache().put(field.getDefinition(), packageName);
            }
        } else {
            packageName = TagCategory.OTHER.getPackageName();
        }
        return packageName;
    }

    private List<String> getMarcPaths(DataField field) {
        ArrayList<String> marcPaths = new ArrayList<String>();
        if (this.parameters.isMarc21()) {
            if (field.getInd1() != null && field.getDefinition() != null && (field.getDefinition().getInd1().exists() || !field.getInd1().equals(" "))) {
                marcPaths.add(field.getTagWithOccurrence() + IND_1);
            }
            if (field.getInd2() != null && field.getDefinition() != null && (field.getDefinition().getInd2().exists() || !field.getInd2().equals(" "))) {
                marcPaths.add(field.getTagWithOccurrence() + IND_2);
            }
        }
        for (MarcSubfield subfield : field.getSubfields()) {
            marcPaths.add(RecordCompleteness.getKey(field, subfield));
        }
        return marcPaths;
    }

    private static String getKey(DataField field, MarcSubfield subfield) {
        String f = field.getTagWithOccurrence();
        String c = subfield.getCode();
        keyMap.computeIfAbsent(f, s -> new HashMap());
        if (!keyMap.get(f).containsKey(c)) {
            String key = numericalPattern.matcher(c).matches() ? f + NUMERICAL_SUBFIELD + c : f + SUBFIELD + c;
            keyMap.get(f).put(c, key);
        }
        return keyMap.get(f).get(c);
    }

    private void addGroupedElementCardinality(String marcPath, String groupId) {
        this.completenessDAO.getGroupedElementCardinality().computeIfAbsent(groupId, s -> new HashMap());
        this.completenessDAO.getGroupedElementCardinality().get(groupId).computeIfAbsent(this.documentType, s -> new HashMap());
        this.completenessDAO.getGroupedElementCardinality().get(groupId).computeIfAbsent("all", s -> new HashMap());
        Utils.count(marcPath, this.completenessDAO.getGroupedElementCardinality().get(groupId).get(this.documentType));
        Utils.count(marcPath, this.completenessDAO.getGroupedElementCardinality().get(groupId).get("all"));
    }
}

