/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.analysis;

import de.gwdg.metadataqa.marc.MarcSubfield;
import de.gwdg.metadataqa.marc.analysis.ShelfReadyFieldsBooks;
import de.gwdg.metadataqa.marc.dao.DataField;
import de.gwdg.metadataqa.marc.dao.record.BibliographicRecord;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ShelfReadyAnalysis {
    private static List<String> headers = new LinkedList<String>();

    private ShelfReadyAnalysis() {
        throw new IllegalStateException("This is a utility class");
    }

    public static List<Double> getScores(BibliographicRecord marcRecord) {
        ArrayList<Double> scores = new ArrayList<Double>();
        double total = 0.0;
        for (Map.Entry<ShelfReadyFieldsBooks, Map<String, List<String>>> fieldEntry : marcRecord.getShelfReadyMap().entrySet()) {
            ShelfReadyFieldsBooks category = fieldEntry.getKey();
            double score = 0.0;
            double count = ShelfReadyAnalysis.countSelectors(fieldEntry.getValue());
            for (Map.Entry<String, List<String>> selector : fieldEntry.getValue().entrySet()) {
                String tag = selector.getKey();
                List<String> codes = selector.getValue();
                if (codes != null && !codes.isEmpty()) {
                    HashSet<CallSite> collector = new HashSet<CallSite>();
                    if (marcRecord.hasDatafield(tag)) {
                        List<DataField> dataFields = marcRecord.getDatafield(tag);
                        for (DataField dataField : dataFields) {
                            for (String code : codes) {
                                List<MarcSubfield> subfield = dataField.getSubfield(code);
                                if (subfield == null || subfield.isEmpty()) continue;
                                collector.add((CallSite)((Object)(tag + "$" + code)));
                            }
                            if (!category.isOneOf()) continue;
                            break;
                        }
                    }
                    score += (double)collector.size();
                    continue;
                }
                count = 1.0;
                List<String> values2 = marcRecord.select(category.getSelectors().get(0));
                if (values2.isEmpty()) continue;
                score += 1.0;
                if (!category.isOneOf()) continue;
                break;
            }
            if (category.isOneOf()) {
                score = category.getScore();
            } else {
                double mean = count == 0.0 ? 0.0 : score / count;
                score = mean * (double)category.getScore();
            }
            scores.add(score);
            total += score;
        }
        scores.add(total /= (double)scores.size());
        return scores;
    }

    public static List<String> getHeaders() {
        return headers;
    }

    private static int countSelectors(Map<String, List<String>> value) {
        int count = 0;
        if (value != null && !value.isEmpty()) {
            for (Map.Entry<String, List<String>> entry : value.entrySet()) {
                if (entry.getValue() == null) {
                    ++count;
                    continue;
                }
                count += entry.getValue().size();
            }
        }
        return count;
    }

    static {
        for (ShelfReadyFieldsBooks field : ShelfReadyFieldsBooks.values()) {
            headers.add(field.name());
        }
    }
}

