/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc;

import java.io.Serializable;
import java.security.InvalidParameterException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Range
implements Serializable {
    private static final Pattern numericRangePattern = Pattern.compile("^(\\d+)-(\\d+)$");
    private String rangeInput;
    private int min;
    private int max;
    boolean validRange = false;

    public Range(String rangeInput) {
        Matcher matcher = numericRangePattern.matcher(rangeInput);
        if (!matcher.find()) {
            throw new InvalidParameterException("Invalid range: " + rangeInput);
        }
        this.min = Integer.parseInt(matcher.group(1));
        this.max = Integer.parseInt(matcher.group(2));
        this.validRange = true;
        this.rangeInput = rangeInput;
    }

    public boolean isValid(String value) {
        try {
            int number = Integer.parseInt(value);
            return this.min <= number && number <= this.max;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public String getRangeInput() {
        return this.rangeInput;
    }
}

