/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc;

import com.jayway.jsonpath.InvalidJsonException;
import de.gwdg.metadataqa.api.calculator.CalculatorFacade;
import de.gwdg.metadataqa.api.calculator.CompletenessCalculator;
import de.gwdg.metadataqa.api.calculator.FieldExtractor;
import de.gwdg.metadataqa.api.calculator.LanguageCalculator;
import de.gwdg.metadataqa.api.calculator.MultilingualitySaturationCalculator;
import de.gwdg.metadataqa.api.calculator.TfIdfCalculator;
import de.gwdg.metadataqa.api.configuration.MeasurementConfiguration;
import de.gwdg.metadataqa.api.schema.MarcJsonSchema;
import de.gwdg.metadataqa.api.schema.Schema;
import java.util.ArrayList;

public class MarcJsonCalculatorFacade
extends CalculatorFacade {
    private MarcJsonSchema marcJsonSchema = new MarcJsonSchema();
    protected FieldExtractor marcFieldExtractor;

    public MarcJsonCalculatorFacade() {
    }

    public MarcJsonCalculatorFacade(MeasurementConfiguration config) {
        super(config);
    }

    public MarcJsonCalculatorFacade(boolean enableFieldExistenceMeasurement, boolean enableFieldCardinalityMeasurement, boolean enableCompletenessMeasurement, boolean enableTfIdfMeasurement, boolean enableProblemCatalogMeasurement) {
        super(new MeasurementConfiguration(enableFieldExistenceMeasurement, enableFieldCardinalityMeasurement, enableCompletenessMeasurement, enableTfIdfMeasurement, enableProblemCatalogMeasurement));
    }

    @Override
    public void configure() {
        this.calculators = new ArrayList();
        this.marcFieldExtractor = new FieldExtractor(this.marcJsonSchema);
        this.calculators.add(this.marcFieldExtractor);
        if (this.configuration.isCompletenessMeasurementEnabled() || this.configuration.isFieldExistenceMeasurementEnabled() || this.configuration.isFieldCardinalityMeasurementEnabled()) {
            this.completenessCalculator = new CompletenessCalculator(this.marcJsonSchema);
            this.completenessCalculator.setCompleteness(this.configuration.isCompletenessMeasurementEnabled());
            this.completenessCalculator.setExistence(this.configuration.isFieldExistenceMeasurementEnabled());
            this.completenessCalculator.setCardinality(this.configuration.isFieldCardinalityMeasurementEnabled());
            this.completenessCalculator.collectFields(this.configuration.isCompletenessFieldCollectingEnabled());
            this.calculators.add(this.completenessCalculator);
        }
        if (this.configuration.isTfIdfMeasurementEnabled()) {
            this.tfidfCalculator = new TfIdfCalculator(this.marcJsonSchema);
            this.tfidfCalculator.enableTermCollection(this.configuration.collectTfIdfTerms());
            this.calculators.add(this.tfidfCalculator);
        }
        if (this.configuration.isLanguageMeasurementEnabled()) {
            this.calculators.add(new LanguageCalculator(this.marcJsonSchema));
        }
        if (this.configuration.isMultilingualSaturationMeasurementEnabled()) {
            MultilingualitySaturationCalculator multilingualSaturationCalculator = new MultilingualitySaturationCalculator(this.marcJsonSchema);
            if (this.configuration.isSaturationExtendedResult()) {
                multilingualSaturationCalculator.setResultType(MultilingualitySaturationCalculator.ResultTypes.EXTENDED);
            }
            this.calculators.add(multilingualSaturationCalculator);
        }
    }

    @Override
    public String measure(String jsonRecord) throws InvalidJsonException {
        return (String)this.measureWithGenerics(jsonRecord);
    }

    @Override
    public Schema getSchema() {
        return this.marcJsonSchema;
    }

    public static enum Formats {
        OAI_PMH_XML("xml"),
        FULLBEAN("fullbean");

        private final String name;

        private Formats(String name) {
            this.name = name;
        }
    }
}

