/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc;

import com.jayway.jsonpath.InvalidJsonException;
import de.gwdg.metadataqa.api.counter.FieldCounter;
import de.gwdg.metadataqa.api.interfaces.Calculator;
import de.gwdg.metadataqa.api.interfaces.MetricResult;
import de.gwdg.metadataqa.api.model.XmlFieldInstance;
import de.gwdg.metadataqa.api.model.selector.JsonSelector;
import de.gwdg.metadataqa.api.model.selector.Selector;
import de.gwdg.metadataqa.api.schema.Schema;
import de.gwdg.metadataqa.api.util.CompressionLevel;
import de.gwdg.metadataqa.marc.X035aSystemControlNumber;
import de.gwdg.metadataqa.marc.dao.Control007;
import de.gwdg.metadataqa.marc.dao.Control008;
import de.gwdg.metadataqa.marc.dao.Leader;
import de.gwdg.metadataqa.marc.definition.general.codelist.CodeList;
import de.gwdg.metadataqa.marc.definition.general.codelist.LanguageCodes;
import de.gwdg.metadataqa.marc.definition.general.codelist.OrganizationCodes;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class MarcFieldExtractor
implements Calculator,
Serializable {
    private static final Logger logger = Logger.getLogger(MarcFieldExtractor.class.getCanonicalName());
    public static final String CALCULATOR_NAME = "fieldExtractor";
    public static final String LEADER_KEY = "leader";
    private static final List<String> authorFields = Arrays.asList("100$a", "110$a", "700$a", "710$a");
    public static final String FIELD_NAME = "recordId";
    private String idPath;
    protected FieldCounter<List<String>> resultMap;
    protected Schema schema;
    private String recordId;
    private Leader leader;
    private Control007 x007;
    private Control008 x008;
    private Map<String, Object> duplumKeyMap;
    private List<String> titleWords;
    private List<String> authorWords;
    private String duplumKeyType;
    private List<String> dateOfPublication;
    private List<String> isbn;
    private String publisherOrDistributorNumber;
    private String abbreviatedNameOfPublisher;
    private String numberOfPart;
    private String nameOfPart;
    private String extent;
    private String musicalPresentationStatement;
    private String volumeDesignation;
    private String relatedParts;
    private List<X035aSystemControlNumber> systemControlNumbers;
    private Map<String, Object> oclcMap;
    private boolean valid;

    public MarcFieldExtractor() {
    }

    public MarcFieldExtractor(Schema schema) {
        this.schema = schema;
        this.setIdPath(schema.getExtractableFields().get("001"));
    }

    public MarcFieldExtractor(String idPath) {
        this.idPath = idPath;
    }

    @Override
    public String getCalculatorName() {
        return CALCULATOR_NAME;
    }

    public void measure(JsonSelector selector) throws InvalidJsonException {
        this.valid = true;
        this.resultMap = new FieldCounter();
        this.duplumKeyMap = null;
        this.recordId = null;
        this.leader = null;
        this.x007 = null;
        this.x008 = null;
        this.titleWords = null;
        this.authorWords = null;
        this.duplumKeyType = null;
        this.dateOfPublication = null;
        this.isbn = null;
        this.publisherOrDistributorNumber = null;
        this.abbreviatedNameOfPublisher = null;
        this.numberOfPart = null;
        this.nameOfPart = null;
        this.extent = null;
        this.musicalPresentationStatement = null;
        this.volumeDesignation = null;
        this.relatedParts = null;
        this.systemControlNumbers = null;
        this.oclcMap = null;
        this.recordId = ((XmlFieldInstance)selector.get(this.getIdPath()).get(0)).getValue();
        selector.setRecordId(this.recordId);
        this.resultMap.put(FIELD_NAME, Arrays.asList(this.recordId));
        if (this.schema != null) {
            for (String fieldName : this.schema.getExtractableFields().keySet()) {
                if (fieldName.equals(FIELD_NAME)) continue;
                String path = this.schema.getExtractableFields().get(fieldName);
                List<XmlFieldInstance> instances = selector.get(path);
                ArrayList<String> values2 = null;
                if (!MarcFieldExtractor.isNull(instances)) {
                    values2 = new ArrayList<String>();
                    for (XmlFieldInstance instance : instances) {
                        values2.add(instance.getValue());
                    }
                    if (fieldName.equals(LEADER_KEY)) {
                        this.leader = new Leader((String)values2.get(0));
                    }
                }
                this.resultMap.put(fieldName, values2);
            }
        }
        this.processLeader();
        this.process007();
        this.process008();
        this.processType();
        this.processTitleWords();
        this.processAuthorWords();
        this.processDateOfPublication();
        this.processIsbn();
        this.processPublisherOrDistributorNumber();
        this.processAbbreviatedNameOfPublisher();
        this.processNumberOfPart();
        this.processNameOfPart();
        this.processExtent();
        this.processMusicalPresentationStatement();
        this.processVolumeDesignation();
        this.processRelatedParts();
        this.processSystemControlNumbers();
        this.processOclcFields();
        this.createDuplumKeyMap();
    }

    private static boolean isNull(List<XmlFieldInstance> values2) {
        return values2 == null || values2.isEmpty() || values2.get(0) == null || values2.get(0).getValue() == null;
    }

    public String getIdPath() {
        return this.idPath;
    }

    public void setIdPath(String idPath) {
        this.idPath = idPath;
    }

    @Override
    public List<MetricResult> measure(Selector selector) {
        return null;
    }

    public Map<String, ? extends Object> getResultMap() {
        return this.resultMap.getMap();
    }

    public Map<String, Map<String, ? extends Object>> getLabelledResultMap() {
        LinkedHashMap<String, Map<String, ? extends Object>> labelledResultMap = new LinkedHashMap<String, Map<String, ? extends Object>>();
        labelledResultMap.put(this.getCalculatorName(), this.resultMap.getMap());
        return labelledResultMap;
    }

    public String getCsv(boolean withLabel, CompressionLevel compressionLevel) {
        return this.resultMap.getCsv(withLabel, CompressionLevel.ZERO);
    }

    @Override
    public List<String> getHeader() {
        ArrayList<String> headers = new ArrayList<String>();
        headers.add(FIELD_NAME);
        return headers;
    }

    public void processLeader() {
        if (this.resultMap.has(LEADER_KEY)) {
            this.leader = new Leader(this.resultMap.get(LEADER_KEY).get(0));
        } else {
            logger.severe("No leader in result map. Nr of existing vars: " + StringUtils.join(this.resultMap.getMap().keySet(), ", "));
        }
    }

    public void process007() {
        if (this.resultMap.get("007") == null) {
            this.valid = false;
        } else {
            this.x007 = new Control007(this.resultMap.get("007").get(0));
        }
    }

    public void process008() {
        if (this.resultMap.get("008") != null && StringUtils.isNotBlank(this.resultMap.get("008").get(0))) {
            this.x008 = new Control008(this.resultMap.get("008").get(0), this.leader.getType());
        }
    }

    private void processTitleWords() {
        this.titleWords = this.extractWords(StringUtils.join((Iterable)this.resultMap.get("245$a"), " "), 3);
    }

    private void processType() {
        String typeOfRecord = this.leader.getByLabel("Type of record");
        String bibliographicLevel = this.leader.getByLabel("Bibliographic level");
        this.duplumKeyType = typeOfRecord.equals("a") && bibliographicLevel.equals("s") ? "p" : (bibliographicLevel.equals("d") ? "s" : (bibliographicLevel.equals("a") || bibliographicLevel.equals("b") ? "a" : "m"));
    }

    public List<String> extractWords(String text, int length) {
        ArrayList<String> tokens = new ArrayList<String>();
        if (StringUtils.isBlank(text)) {
            return tokens;
        }
        StringTokenizer st = new StringTokenizer(text);
        while (st.hasMoreTokens()) {
            tokens.add(st.nextToken());
        }
        int max = Math.min(length, tokens.size());
        return tokens.subList(0, max);
    }

    public String getRecordId() {
        return this.recordId;
    }

    public Leader getLeader() {
        return this.leader;
    }

    public Control007 getX007() {
        return this.x007;
    }

    public Control008 getX008() {
        return this.x008;
    }

    public List<String> getTitleWords() {
        return this.titleWords;
    }

    public List<String> getAuthorWords() {
        return this.authorWords;
    }

    public String getDuplumKeyType() {
        return this.duplumKeyType;
    }

    public List<String> getDateOfPublication() {
        return this.dateOfPublication;
    }

    public List<String> getIsbn() {
        return this.isbn;
    }

    public String getPublisherOrDistributorNumber() {
        return this.publisherOrDistributorNumber;
    }

    public String getAbbreviatedNameOfPublisher() {
        return this.abbreviatedNameOfPublisher;
    }

    public String getNumberOfPart() {
        return this.numberOfPart;
    }

    public String getNameOfPart() {
        return this.nameOfPart;
    }

    public String getExtent() {
        return this.extent;
    }

    public String getMusicalPresentationStatement() {
        return this.musicalPresentationStatement;
    }

    public String getVolumeDesignation() {
        return this.volumeDesignation;
    }

    public String getRelatedParts() {
        return this.relatedParts;
    }

    private void processAuthorWords() {
        String author = this.extractAuthor();
        this.authorWords = this.extractWords(author, 3);
    }

    private String extractAuthor() {
        String author = null;
        for (String field : authorFields) {
            List<String> value = this.resultMap.get(field);
            String stringValue = value instanceof List ? StringUtils.join(value, " ") : (String)((Object)value);
            if (!StringUtils.isNotBlank(stringValue)) continue;
            author = stringValue;
            break;
        }
        return author;
    }

    private void processDateOfPublication() {
        this.dateOfPublication = this.resultMap.get("260$c");
    }

    private void processIsbn() {
        this.isbn = this.resultMap.get("020$a");
    }

    private void processPublisherOrDistributorNumber() {
        this.publisherOrDistributorNumber = this.duplumKeyType.equals("m") ? null : StringUtils.join((Iterable)this.resultMap.get("028$a"), "; ");
    }

    private void processAbbreviatedNameOfPublisher() {
        this.abbreviatedNameOfPublisher = StringUtils.join((Iterable)this.resultMap.get("060$b"), "; ");
    }

    private void processNumberOfPart() {
        this.numberOfPart = StringUtils.join((Iterable)this.resultMap.get("245$n"), "; ");
    }

    private void processNameOfPart() {
        this.nameOfPart = StringUtils.join((Iterable)this.resultMap.get("245$p"), "; ");
    }

    private void processExtent() {
        this.extent = StringUtils.join((Iterable)this.resultMap.get("300$a"), "; ");
    }

    private void processMusicalPresentationStatement() {
        this.musicalPresentationStatement = StringUtils.join((Iterable)this.resultMap.get("254$a"), "; ");
    }

    private void processVolumeDesignation() {
        this.volumeDesignation = StringUtils.join((Iterable)this.resultMap.get("490$v"), "; ");
    }

    private void processRelatedParts() {
        this.relatedParts = StringUtils.join((Iterable)this.resultMap.get("773$g"), "; ");
    }

    private void processOclcFields() {
        this.oclcMap = new LinkedHashMap<String, Object>();
        this.oclcMap.put("oclcLibraryIdentifier", this.resolve(this.resultMap.get("029$a"), OrganizationCodes.getInstance()));
        this.oclcMap.put("otherSystemControlNumber", this.resultMap.get("029$b"));
        this.oclcMap.put("catalogingAgency", this.resolve(this.resultMap.get("040$a"), OrganizationCodes.getInstance()));
        this.oclcMap.put("languageOfCataloging", this.resolve(this.resultMap.get("040$b"), LanguageCodes.getInstance()));
        this.oclcMap.put("transcribingAgency", this.resolve(this.resultMap.get("040$c"), OrganizationCodes.getInstance()));
        this.oclcMap.put("modifyingAgency", this.resolve(this.resultMap.get("040$d"), OrganizationCodes.getInstance()));
        this.oclcMap.put("topicalTerm", this.resultMap.get("650$a"));
        this.oclcMap.put("manifestId", this.resultMap.get("911$9"));
        this.oclcMap.put("workId", this.resultMap.get("912$9"));
        this.oclcMap.put("placeOfPublication", this.resultMap.get("260$a"));
        this.oclcMap.put("nameOfPublisher", this.resultMap.get("260$b"));
        this.oclcMap.put("sourceOfHeading", this.resultMap.get("650$2"));
        this.oclcMap.put("title", this.resultMap.get("245$a"));
    }

    private Object resolve(List<String> list, CodeList codeService) {
        if (list == null || list.isEmpty()) {
            return list;
        }
        ArrayList<String> resolvedList = new ArrayList<String>();
        for (String code : list) {
            if (codeService.isValid(code)) {
                resolvedList.add(codeService.getCode(code).getLabel());
                continue;
            }
            resolvedList.add(code);
        }
        return resolvedList;
    }

    public Map<String, Object> getDuplumKeyMap() {
        if (this.duplumKeyMap == null) {
            this.createDuplumKeyMap();
        }
        return this.duplumKeyMap;
    }

    public void createDuplumKeyMap() {
        this.duplumKeyMap = new HashMap<String, Object>();
        this.duplumKeyMap.put(FIELD_NAME, this.recordId);
        this.duplumKeyMap.put("titleWords", this.titleWords);
        this.duplumKeyMap.put("authorWords", this.authorWords);
        this.duplumKeyMap.put("duplumKeyType", this.duplumKeyType);
        this.duplumKeyMap.put("dateOfPublication", this.dateOfPublication);
        this.duplumKeyMap.put("isbn", this.isbn);
        this.duplumKeyMap.put("publisherOrDistributorNumber", this.publisherOrDistributorNumber);
        this.duplumKeyMap.put("abbreviatedNameOfPublisher", this.abbreviatedNameOfPublisher);
        this.duplumKeyMap.put("numberOfPart", this.numberOfPart);
        this.duplumKeyMap.put("nameOfPart", this.nameOfPart);
        this.duplumKeyMap.put("extent", this.extent);
        this.duplumKeyMap.put("musicalPresentationStatement", this.musicalPresentationStatement);
        this.duplumKeyMap.put("volumeDesignation", this.volumeDesignation);
        this.duplumKeyMap.put("relatedParts", this.relatedParts);
        this.duplumKeyMap.put("systemControlNumbers", this.systemControlNumbers);
        for (Map.Entry<String, Object> entry : this.oclcMap.entrySet()) {
            this.duplumKeyMap.put(entry.getKey(), entry.getValue());
        }
    }

    public boolean isValid() {
        return this.valid;
    }

    private void processSystemControlNumbers() {
        this.systemControlNumbers = new ArrayList<X035aSystemControlNumber>();
        if (this.resultMap.get("035$a") != null) {
            for (String original : this.resultMap.get("035$a")) {
                this.systemControlNumbers.add(new X035aSystemControlNumber(original));
            }
        }
    }
}

