/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc;

import com.opencsv.CSVWriter;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class CsvUtils {
    private static final Logger logger = Logger.getLogger(CsvUtils.class.getCanonicalName());

    private CsvUtils() {
    }

    public static String createCsv(List<? extends Serializable> values2) {
        return CsvUtils.createCsv(CsvUtils.asArray(values2));
    }

    public static String createCsvFromObjects(List<Object> values2) {
        return CsvUtils.createCsv(CsvUtils.asArrayFromObject(values2));
    }

    public static String createCsv(Object ... values2) {
        return CsvUtils.createCsv(CsvUtils.asArrayFromObject(Stream.of(values2).collect(Collectors.toList())));
    }

    public static String createCsv(String[] values2) {
        String csv = null;
        try (StringWriter sw = new StringWriter();
             CSVWriter csvWriter = new CSVWriter(sw);){
            csvWriter.writeNext(CsvUtils.cleanRow(values2), false);
            csv = sw.toString();
        }
        catch (IOException e) {
            logger.severe(e.getLocalizedMessage());
        }
        return csv;
    }

    private static String[] asArray(List<? extends Serializable> values2) {
        ArrayList<String> strings = new ArrayList<String>();
        for (Serializable serializable : values2) {
            if (serializable instanceof String) {
                strings.add((String)((Object)serializable));
                continue;
            }
            if (serializable == null) {
                strings.add("");
                continue;
            }
            strings.add(serializable.toString());
        }
        return strings.toArray(new String[strings.size()]);
    }

    private static String[] asArrayFromObject(List<Object> values2) {
        ArrayList<String> strings = new ArrayList<String>();
        for (Object value : values2) {
            if (value instanceof String) {
                strings.add((String)value);
                continue;
            }
            if (value == null) {
                strings.add("");
                continue;
            }
            strings.add(value.toString());
        }
        return strings.toArray(new String[strings.size()]);
    }

    private static String[] cleanRow(String[] values2) {
        ArrayList<Object> quoted = new ArrayList<Object>();
        for (String value : values2) {
            quoted.add(CsvUtils.cleanCell(value));
        }
        return quoted.toArray(new String[quoted.size()]);
    }

    private static Object cleanCell(Object value) {
        if (value instanceof String) {
            return ((String)value).replace("\n", "\\n");
        }
        return value;
    }
}

