/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.api.xml;

import de.gwdg.metadataqa.api.model.EdmFieldInstance;
import de.gwdg.metadataqa.api.xml.XpathEngineFactory;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XPathWrapper
implements Serializable {
    private static final long serialVersionUID = 3040547541095974755L;
    private static final Logger LOGGER = Logger.getLogger(XPathWrapper.class.getCanonicalName());
    private static transient XPath xpathEngine;
    private static final DocumentBuilder builder;
    private static transient Map<String, String> namespaces;
    private boolean namespaceChanged = false;
    Document document;

    private static DocumentBuilder initializeDocumentBuilder() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        return builder;
    }

    public XPathWrapper(String input) {
        this.parseContent(input);
    }

    public XPathWrapper(String input, Map<String, String> customNamespaces) {
        if (namespaces != customNamespaces) {
            this.namespaceChanged = true;
            namespaces = customNamespaces;
        }
        this.parseContent(input);
    }

    public XPathWrapper(File input) {
        this.parseFile(input.getPath());
    }

    public XPathWrapper(File input, Map<String, String> customNamespaces) {
        if (namespaces != customNamespaces) {
            this.namespaceChanged = true;
            namespaces = customNamespaces;
        }
        this.parseFile(input.getPath());
    }

    private void initialize() {
        if (xpathEngine == null || this.namespaceChanged) {
            LOGGER.info("initialize xpathEngine");
            if (namespaces == null) {
                LOGGER.info("initialize without namespaces");
                xpathEngine = XpathEngineFactory.initializeEngine();
            } else {
                xpathEngine = XpathEngineFactory.initializeEngine(namespaces);
            }
        }
    }

    public XPathWrapper(String input, boolean fromString) {
        if (fromString) {
            this.parseContent(input);
        } else {
            this.parseFile(input);
        }
    }

    private void parseFile(String path) {
        this.initialize();
        try {
            this.document = builder.parse(path);
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "buildUrl", e);
        }
    }

    public void parseContent(String content) {
        this.initialize();
        this.parseContent(new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8)));
    }

    private void parseContent(InputStream content) {
        try {
            this.document = builder.parse(content);
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "parseContent", e);
        }
    }

    public List<EdmFieldInstance> extractFieldInstanceList(String xpath) {
        return this.extractFieldInstanceList(this.document, xpath);
    }

    public List<EdmFieldInstance> extractFieldInstanceList(Object context, String xpath) {
        ArrayList<EdmFieldInstance> list = new ArrayList<EdmFieldInstance>();
        try {
            XPathExpression expr = xpathEngine.compile(xpath);
            if (xpath.endsWith(")")) {
                String value = String.valueOf(expr.evaluate(context, XPathConstants.STRING));
                list.add(new EdmFieldInstance(value, null, null));
            } else {
                NodeList nodes = (NodeList)expr.evaluate(context, XPathConstants.NODESET);
                for (int i = 0; i < nodes.getLength(); ++i) {
                    String value;
                    Node node = nodes.item(i);
                    if (node.getNodeType() == 1) {
                        value = node.getTextContent();
                        String lang = null;
                        String resource = null;
                        if (node.hasAttributes()) {
                            NamedNodeMap attributes = node.getAttributes();
                            lang = this.getAttribute(attributes, "xml", "lang");
                            resource = this.getAttribute(attributes, "rdf", "resource");
                        }
                        list.add(new EdmFieldInstance(value, lang, resource));
                        continue;
                    }
                    if (node.getNodeType() != 2) continue;
                    value = node.getNodeValue();
                    list.add(new EdmFieldInstance(value, null, null));
                }
            }
        }
        catch (XPathExpressionException e) {
            LOGGER.log(Level.WARNING, "extractFieldInstanceList", e);
        }
        return list;
    }

    public List<Node> extractNodes(String xpath) {
        return this.extractNodes(this.document, xpath);
    }

    public List<Node> extractNodes(Object context, String xpath) {
        ArrayList<Node> list = new ArrayList<Node>();
        try {
            XPathExpression expr = xpathEngine.compile(xpath);
            NodeList nodes = (NodeList)expr.evaluate(context, XPathConstants.NODESET);
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                if (node.getNodeType() == 1) {
                    list.add(node);
                    continue;
                }
                if (node.getNodeType() != 2) continue;
                list.add(node);
            }
        }
        catch (XPathExpressionException e) {
            LOGGER.log(Level.WARNING, "extractNodes", e);
        }
        return list;
    }

    public String getAttribute(NamedNodeMap attributes, String prefix, String name) {
        Node attribute = attributes.getNamedItemNS(xpathEngine.getNamespaceContext().getNamespaceURI(prefix), name);
        String value = null;
        if (attribute != null) {
            value = attribute.getNodeValue();
        }
        return value;
    }

    public XPath getXpathEngine() {
        return xpathEngine;
    }

    public Document getDocument() {
        return this.document;
    }

    public static void setXpathEngine(XPath _xpathEngine) {
        xpathEngine = _xpathEngine;
    }

    public static void setXpathEngine(Map<String, String> namespaces) {
        xpathEngine = XpathEngineFactory.initializeEngine(namespaces);
    }

    static {
        builder = XPathWrapper.initializeDocumentBuilder();
    }
}

