/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.api.util;

public final class StringDuplicationDetector {
    private StringDuplicationDetector() {
    }

    private static boolean isLineBreakInTheMiddle(String middlePart) {
        return middlePart.substring(1, 2).matches("\n");
    }

    private static boolean isCommaInTheMiddle(String middlePart) {
        return middlePart.substring(1, 2).matches("[,;]");
    }

    private static boolean isSpaceCommaSpace(String middlePart) {
        return middlePart.matches(" [,;] ");
    }

    public static boolean isDuplicated(String input) {
        int len = input.length();
        if (StringDuplicationDetector.isEven(len)) {
            int half = len / 2;
            if (StringDuplicationDetector.hasEqualParts(input, half, half)) {
                return true;
            }
            if (input.substring(half, half + 1).equals(" ") && input.substring(half - 1, half).matches("[;,]")) {
                return StringDuplicationDetector.hasEqualParts(input, half - 1, half + 1);
            }
        } else {
            int half = len / 2;
            String middlePart = input.substring(half - 1, half + 2);
            if (StringDuplicationDetector.isSpaceCommaSpace(middlePart)) {
                return StringDuplicationDetector.hasEqualParts(input, half - 1, half + 2);
            }
            if (StringDuplicationDetector.isCommaInTheMiddle(middlePart) || StringDuplicationDetector.isLineBreakInTheMiddle(middlePart)) {
                return StringDuplicationDetector.hasEqualParts(input, half, half + 1);
            }
        }
        return false;
    }

    private static boolean isEven(int len) {
        return len % 2 == 0;
    }

    private static boolean hasEqualParts(String input, int beginTo, int endFrom) {
        String begin = input.substring(0, beginTo);
        String end = input.substring(endFrom);
        return begin.equals(end);
    }
}

