/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.api.util;

import de.gwdg.metadataqa.api.configuration.SchemaConfiguration;
import de.gwdg.metadataqa.api.configuration.schema.Field;
import de.gwdg.metadataqa.api.configuration.schema.Group;
import de.gwdg.metadataqa.api.json.DataElement;
import de.gwdg.metadataqa.api.json.FieldGroup;
import de.gwdg.metadataqa.api.schema.BaseSchema;
import de.gwdg.metadataqa.api.schema.Format;
import de.gwdg.metadataqa.api.schema.Schema;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class SchemaFactory {
    private static final Logger LOGGER = Logger.getLogger(SchemaFactory.class.getCanonicalName());

    private SchemaFactory() {
    }

    public static Schema fromConfig(SchemaConfiguration config) {
        BaseSchema schema = new BaseSchema().setFormat(Format.valueOf(config.getFormat().toUpperCase()));
        boolean hasCategories = config.hasCategories();
        if (hasCategories) {
            schema.setCategories(config.getCategories());
        }
        for (Field field : config.getFields()) {
            DataElement branch = new DataElement(field.getName());
            if (StringUtils.isNotBlank(field.getPath())) {
                branch.setPath(field.getPath());
            }
            if (field.getCategories() != null) {
                ArrayList<String> categories = new ArrayList<String>();
                for (String category : field.getCategories()) {
                    if (hasCategories) {
                        if (config.getCategories().contains(category)) {
                            categories.add(category);
                            continue;
                        }
                        LOGGER.warning(String.format("Invalid category for field '%s': '%s'", field.getName(), category));
                        continue;
                    }
                    categories.add(category);
                }
                branch.setCategories(categories);
            }
            if (field.isExtractable()) {
                branch.setExtractable();
            }
            if (field.isInactive()) {
                branch.setActive(false);
            }
            if (field.getRules() != null) {
                branch.setRule(field.getRules());
            }
            if (StringUtils.isNotBlank(field.getIndexField())) {
                branch.setIndexField(field.getIndexField());
            }
            schema.addField(branch);
            if (!field.isIdentifierField()) continue;
            schema.setRecordId(branch);
        }
        if (config.getGroups() != null) {
            for (Group group : config.getGroups()) {
                for (String category : group.getCategories()) {
                    schema.addFieldGroup(new FieldGroup(category, group.getFields()));
                }
            }
        }
        if (config.getNamespaces() != null) {
            schema.setNamespaces(config.getNamespaces());
        }
        schema.checkConsistency();
        return schema;
    }
}

