/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.api.util;

import com.opencsv.CSVParser;
import com.opencsv.CSVWriter;
import com.opencsv.ICSVParser;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class CsvReader
implements Serializable {
    private static final long serialVersionUID = 2096388277803061095L;
    private List<String> header;
    private ICSVParser parser;
    private boolean headerAware;

    public CsvReader() {
        this.parser = new CSVParser();
    }

    public CsvReader(ICSVParser parser) {
        this.parser = parser;
    }

    public CsvReader setHeader(List<String> header) {
        this.header = header;
        return this;
    }

    public CsvReader setHeader(String[] header) {
        this.header = Arrays.asList(header);
        return this;
    }

    public CsvReader setHeader(String header) throws IOException {
        this.header = Arrays.asList(this.asArray(header));
        return this;
    }

    public List<String> getHeader() {
        return this.header;
    }

    public String[] asArray(String input) throws IOException {
        return this.parser.parseLine(input);
    }

    public Map<String, String> asMap(String input) throws IOException {
        String[] columns = this.asArray(input);
        return this.createMap(columns);
    }

    public Map<String, String> createMap(String[] columns) {
        LinkedHashMap<String, String> record = new LinkedHashMap<String, String>();
        if (this.header != null && columns.length == this.header.size()) {
            for (int i = 0; i < columns.length; ++i) {
                record.put(this.header.get(i), columns[i]);
            }
        } else {
            throw new IllegalArgumentException(String.format("The size of columns (%d) is different than the size of headers (%d)", columns == null ? 0 : columns.length, this.header == null ? 0 : this.header.size()));
        }
        return record;
    }

    public Map<String, String> createMap(List<String> columns) {
        LinkedHashMap<String, String> record = new LinkedHashMap<String, String>();
        if (this.header != null && columns.size() == this.header.size()) {
            for (int i = 0; i < columns.size(); ++i) {
                record.put(this.header.get(i), columns.get(i));
            }
        } else {
            throw new IllegalArgumentException("The size of columns are different than the size of headers");
        }
        return record;
    }

    public static String toCsv(String[] cells) throws IOException {
        StringWriter stringWriter = new StringWriter();
        CSVWriter csvWriter = new CSVWriter(stringWriter);
        csvWriter.writeNext(cells);
        csvWriter.close();
        return stringWriter.toString().trim();
    }

    public boolean isHeaderAware() {
        return this.headerAware;
    }

    public CsvReader setHeaderAware(boolean headerAware) {
        this.headerAware = headerAware;
        return this;
    }
}

