/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.api.util;

import de.gwdg.metadataqa.api.rule.RuleCheckerOutput;
import de.gwdg.metadataqa.api.rule.RuleCheckingOutputStatus;
import de.gwdg.metadataqa.api.schema.Format;
import de.gwdg.metadataqa.api.schema.Schema;
import de.gwdg.metadataqa.api.util.CompressionLevel;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import net.minidev.json.JSONArray;
import org.apache.commons.lang3.StringUtils;

public interface Converter {
    public static Double asDouble(Object value) {
        double doubleValue;
        switch (value.getClass().getCanonicalName()) {
            case "java.math.BigDecimal": {
                doubleValue = ((BigDecimal)value).doubleValue();
                break;
            }
            case "java.lang.Integer": {
                doubleValue = ((Integer)value).doubleValue();
                break;
            }
            case "java.lang.String": {
                doubleValue = Double.parseDouble((String)value);
                break;
            }
            default: {
                doubleValue = (Double)value;
            }
        }
        return doubleValue;
    }

    public static Integer asInteger(Object value) {
        int intValue;
        switch (value.getClass().getCanonicalName()) {
            case "java.math.BigDecimal": {
                intValue = ((BigDecimal)value).intValue();
                break;
            }
            case "java.lang.Boolean": {
                intValue = Boolean.TRUE.equals(value) ? 1 : 0;
                break;
            }
            case "java.lang.Integer": {
                intValue = (Integer)value;
                break;
            }
            case "java.lang.Double": {
                intValue = Long.valueOf(Math.round((Double)value)).intValue();
                break;
            }
            case "java.lang.Long": {
                intValue = ((Long)value).intValue();
                break;
            }
            case "java.lang.Float": {
                intValue = Math.round(((Float)value).floatValue());
                break;
            }
            case "java.lang.String": {
                intValue = Converter.asInteger(Double.parseDouble((String)value));
                break;
            }
            default: {
                intValue = (Integer)value;
            }
        }
        return intValue;
    }

    public static String asString(Object value) {
        String text = "";
        if (value == null) {
            text = "null";
        } else if (value instanceof Boolean) {
            text = Boolean.TRUE.equals(value) ? "1" : "0";
        } else if (value instanceof Integer) {
            text = Integer.toString((Integer)value);
        } else if (value instanceof Double) {
            text = String.format("%.6f", (Double)value);
        } else if (value instanceof String) {
            text = (String)value;
        } else if (value instanceof List) {
            text = StringUtils.join((List)value, ", ");
        } else if (value instanceof RuleCheckingOutputStatus) {
            text = ((RuleCheckingOutputStatus)((Object)value)).asString();
        } else if (value instanceof RuleCheckerOutput) {
            text = ((RuleCheckerOutput)value).toString();
        } else if (value instanceof BigDecimal) {
            text = value.toString();
        } else {
            throw new IllegalArgumentException("Object has an unhandled type: " + value.getClass().getCanonicalName() + " " + value);
        }
        return text;
    }

    public static String compressNumber(String value, CompressionLevel compressionLevel) {
        value = value.replaceAll("([0-9])0+$", "$1");
        if (compressionLevel.equals((Object)CompressionLevel.NORMAL)) {
            value = value.replaceAll("\\.0+$", ".0");
        } else if (compressionLevel.equals((Object)CompressionLevel.WITHOUT_TRAILING_ZEROS)) {
            value = value.replaceAll("\\.0+$", "");
        }
        return value;
    }

    public static List<Object> jsonObjectToList(Object jsonFragment, Schema schema) {
        List list = null;
        list = schema.getFormat().equals((Object)Format.JSON) ? Converter.jsonObjectToList(jsonFragment) : (List)jsonFragment;
        return list;
    }

    public static List<Object> jsonObjectToList(Object jsonFragment) {
        ArrayList<Object> list = new ArrayList<Object>();
        if (jsonFragment != null) {
            if (jsonFragment instanceof JSONArray) {
                List<Object> objects = Arrays.asList(((JSONArray)jsonFragment).toArray());
                if (!objects.isEmpty()) {
                    list.addAll(objects);
                }
            } else if (jsonFragment instanceof LinkedHashMap) {
                if (!((LinkedHashMap)jsonFragment).isEmpty()) {
                    list.add(jsonFragment);
                }
            } else {
                list.add(jsonFragment);
            }
        }
        return list;
    }
}

