/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.api.uniqueness;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.spi.json.JsonProvider;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class UniquenessExtractor
implements Serializable {
    private static final Logger LOGGER = Logger.getLogger(UniquenessExtractor.class.getCanonicalName());
    private static final JsonProvider JSON_PROVIDER = Configuration.defaultConfiguration().jsonProvider();
    private static final long serialVersionUID = -4924105546725077045L;

    public static Integer extractNumFound(String jsonString) {
        int numFound = 1;
        if (StringUtils.isBlank(jsonString)) {
            return numFound;
        }
        Object document = JSON_PROVIDER.parse(jsonString);
        if (document instanceof LinkedHashMap) {
            LinkedHashMap documentMap = (LinkedHashMap)document;
            if (documentMap.containsKey("response")) {
                LinkedHashMap response = (LinkedHashMap)documentMap.get("response");
                numFound = (Integer)response.get("numFound");
            } else {
                LOGGER.severe("No 'response' part in Solr response: " + jsonString);
            }
        } else {
            LOGGER.severe(String.format("Problem with parsing Solr response: >>%s<< class: %s", document, document.getClass()));
        }
        return numFound;
    }
}

