/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.api.uniqueness;

import de.gwdg.metadataqa.api.uniqueness.SolrClient;
import de.gwdg.metadataqa.api.uniqueness.SolrConfiguration;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.BaseHttpSolrClient;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.common.SolrInputDocument;

public class DefaultSolrClient
implements SolrClient,
Serializable {
    private static final Logger LOGGER = Logger.getLogger(DefaultSolrClient.class.getCanonicalName());
    private static final String USER_AGENT = "Custom Java application";
    private static final int VALUE_LIMIT = 50;
    private static final String SOLR_SEARCH_ALL_PARAMS = "select/?q=%s:%s&rows=0";
    private static final String SOLR_SEARCH_PARAMS = "select/?q=%s:%%22%s%%22&rows=0";
    private String solrBasePath;
    private String solrSearchPattern;
    private String solrSearchAllPattern;
    private SolrConfiguration solrConfiguration;
    private HttpSolrClient solr;
    boolean trimId = true;

    public DefaultSolrClient(SolrConfiguration solrConfiguration) {
        this.solrConfiguration = solrConfiguration;
        this.solr = new HttpSolrClient.Builder(solrConfiguration.getUrl()).build();
    }

    @Override
    public String getSolrSearchResponse(String solrField, String value) {
        String url = this.buildUrl(solrField, value);
        return this.connect(url, solrField, value);
    }

    @Override
    public String getTfIdfResponse(String params, String recordId) {
        return this.connect(this.getSolrBasePath() + params, "tf-idf", recordId);
    }

    public String buildUrl(String solrField, String value) {
        String url;
        if (value.equals("*")) {
            url = String.format(this.getSolrSearchAllPattern(), solrField, value);
        } else {
            try {
                value = value.replace("\"", "\\\"");
                String encodedValue = URLEncoder.encode(value, "UTF-8");
                url = String.format(this.getSolrSearchPattern(), solrField, encodedValue);
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.log(Level.WARNING, "buildUrl", e);
                url = String.format(this.getSolrSearchPattern(), solrField, value);
            }
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String connect(String url, String solrField, String value) {
        String record;
        block11: {
            URL fragmentPostUrl = null;
            record = null;
            try {
                fragmentPostUrl = new URL(url);
                HttpURLConnection urlConnection = null;
                try {
                    urlConnection = (HttpURLConnection)fragmentPostUrl.openConnection();
                    urlConnection.setRequestMethod("GET");
                    urlConnection.setRequestProperty("User-Agent", USER_AGENT);
                    urlConnection.setRequestProperty("Accept-Language", "en-US,en;q=0.5");
                    urlConnection.setDoOutput(true);
                    try {
                        if (urlConnection.getResponseCode() == 200) {
                            BufferedInputStream in = new BufferedInputStream(urlConnection.getInputStream());
                            record = this.readStream(in);
                            break block11;
                        }
                        int lenght = urlConnection.getContentLength();
                        LOGGER.severe(String.format("%s: %s returned code %d. Solr responde: %s", solrField, value.length() < 50 ? value : value.substring(0, 50) + "...", urlConnection.getResponseCode(), lenght == 0 ? "" : this.readStream(new BufferedInputStream(urlConnection.getInputStream()))));
                    }
                    catch (IOException e) {
                        LOGGER.severe("Error with connecting to " + url + ": " + e.getMessage());
                    }
                }
                catch (IOException e) {
                    LOGGER.severe("Error with connecting to " + url + ": " + e.getMessage());
                }
                finally {
                    if (urlConnection != null) {
                        urlConnection.disconnect();
                    }
                }
            }
            catch (MalformedURLException e) {
                LOGGER.severe("Error with connecting to " + url + ": " + e.getMessage());
            }
        }
        return record;
    }

    private String readStream(InputStream in) throws IOException {
        BufferedReader rd = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
        StringBuffer result2 = new StringBuffer();
        String line = "";
        while ((line = rd.readLine()) != null) {
            result2.append(line);
        }
        return result2.toString();
    }

    public String getSolrBasePath() {
        if (this.solrBasePath == null) {
            this.solrBasePath = String.format("http://%s:%s/%s", this.solrConfiguration.getSolrHost(), this.solrConfiguration.getSolrPort(), this.solrConfiguration.getSolrPath());
        }
        return this.solrBasePath;
    }

    public String getSolrSearchPattern() {
        if (this.solrSearchPattern == null) {
            this.solrSearchPattern = String.format("%s/%s", this.getSolrBasePath(), SOLR_SEARCH_PARAMS);
        }
        return this.solrSearchPattern;
    }

    public String getSolrSearchAllPattern() {
        if (this.solrSearchAllPattern == null) {
            this.solrSearchAllPattern = String.format("%s/%s", this.getSolrBasePath(), SOLR_SEARCH_ALL_PARAMS);
        }
        return this.solrSearchAllPattern;
    }

    @Override
    public void indexMap(String id, Map<String, List<String>> objectMap) throws IOException, SolrServerException {
        SolrInputDocument document = new SolrInputDocument();
        document.addField("id", this.trimId ? id.trim() : id);
        for (Map.Entry<String, List<String>> entry : objectMap.entrySet()) {
            Object key = entry.getKey();
            List<String> value = entry.getValue();
            if (value == null) continue;
            if (!((String)key).endsWith("_sni") && !((String)key).endsWith("_ss")) {
                key = (String)key + "_ss";
            }
            document.addField((String)key, value);
        }
        try {
            this.solr.add(document);
        }
        catch (BaseHttpSolrClient.RemoteSolrException ex) {
            LOGGER.log(Level.WARNING, "document", document);
            LOGGER.log(Level.WARNING, "Commit exception", ex);
        }
    }

    @Override
    public void commit() {
        try {
            this.solr.commit();
        }
        catch (SolrServerException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void deleteAll() {
        try {
            this.solr.deleteByQuery("*:*");
        }
        catch (SolrServerException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.commit();
    }
}

