/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.api.similarity;

import de.gwdg.metadataqa.api.similarity.Cluster;
import de.gwdg.metadataqa.api.similarity.Term;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.text.similarity.JaroWinklerSimilarity;

public class Clustering {
    private JaroWinklerSimilarity jaroWinkler = new JaroWinklerSimilarity();
    private Map<String, Cluster> clusterIndex = new HashMap<String, Cluster>();
    private double treshold;

    public Clustering(List<String> patterns, double treshold) {
        this.treshold = treshold;
        this.initializeClusters(patterns);
        this.makeClusters();
    }

    public Map<String, Cluster> getClusterIndex() {
        return this.clusterIndex;
    }

    public List<List<String>> getClusters() {
        ArrayList<List<String>> clusters = new ArrayList<List<String>>();
        for (Cluster cluster : this.clusterIndex.values()) {
            clusters.add(cluster.getTermList());
        }
        return clusters;
    }

    private void initializeClusters(List<String> patterns) {
        for (int i = 0; i < patterns.size(); ++i) {
            String pattern = patterns.get(i);
            Term term = this.getOrCreateTerm(pattern);
            for (int j = i + 1; j < patterns.size(); ++j) {
                String otherPattern = patterns.get(j);
                Term otherTerm = this.getOrCreateTerm(otherPattern);
                double distance = this.jaroWinkler.apply(pattern, otherPattern);
                System.err.printf("%s vs %s: %f\n", pattern, otherPattern, distance);
                if (!(distance >= this.treshold)) continue;
                term.setDistance(otherTerm, distance);
                otherTerm.setDistance(term, distance);
            }
        }
    }

    private void makeClusters() {
        ArrayList<Cluster> clusts = new ArrayList<Cluster>(this.clusterIndex.values());
        for (int i = 0; i < clusts.size(); ++i) {
            Cluster a = (Cluster)clusts.get(i);
            if (!a.isActive()) continue;
            for (int j = i + 1; j < clusts.size(); ++j) {
                Cluster b = (Cluster)clusts.get(j);
                if (!b.isActive() || !a.isSimilarTo(b, this.treshold)) continue;
                a.merge(b);
                b.setActive(false);
            }
        }
        this.removePassiveClusters();
    }

    private void removePassiveClusters() {
        ArrayList<String> removableIds = new ArrayList<String>();
        for (Map.Entry<String, Cluster> cluster : this.clusterIndex.entrySet()) {
            if (cluster.getValue().isActive()) continue;
            removableIds.add(cluster.getKey());
        }
        if (!removableIds.isEmpty()) {
            for (String id : removableIds) {
                this.clusterIndex.remove(id);
            }
        }
    }

    private Term getOrCreateTerm(String pattern) {
        Term term = null;
        if (this.clusterIndex.containsKey(pattern)) {
            term = this.clusterIndex.get(pattern).getTerms().get(0);
        } else {
            term = new Term(pattern);
            this.clusterIndex.put(pattern, new Cluster(term));
        }
        return term;
    }
}

