/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.api.similarity;

import de.gwdg.metadataqa.api.similarity.Term;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Cluster
implements Iterable<Term> {
    private List<Term> terms = new ArrayList<Term>();
    private boolean isActive = true;

    public Cluster(Term term) {
        this.terms.add(term);
    }

    @Override
    public Iterator<Term> iterator() {
        return this.terms.iterator();
    }

    public Cluster addTerm(Term term) {
        this.terms.add(term);
        return this;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setActive(boolean active) {
        this.isActive = active;
    }

    public List<Term> getTerms() {
        return this.terms;
    }

    public Cluster merge(Cluster other) {
        for (Term term : other.getTerms()) {
            this.addTerm(term);
        }
        return this;
    }

    public boolean isSimilarTo(Cluster other, double treshold) {
        boolean isSimilar = false;
        for (Term term : this.terms) {
            for (Term otherTerm : other.getTerms()) {
                if (term.hasDistance(otherTerm) && term.getDistance(otherTerm) > treshold) {
                    isSimilar = true;
                    continue;
                }
                isSimilar = false;
                break;
            }
            if (isSimilar) continue;
            break;
        }
        return isSimilar;
    }

    public List<String> getTermList() {
        ArrayList<String> termList = new ArrayList<String>();
        for (Term term : this.terms) {
            termList.add(term.value);
        }
        return termList;
    }

    public String toString() {
        return "Cluster{terms=" + this.terms + ", active=" + this.isActive + "}";
    }
}

