/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.api.schema;

import de.gwdg.metadataqa.api.configuration.schema.Rule;
import de.gwdg.metadataqa.api.json.DataElement;
import de.gwdg.metadataqa.api.json.FieldGroup;
import de.gwdg.metadataqa.api.model.Category;
import de.gwdg.metadataqa.api.rule.RuleChecker;
import de.gwdg.metadataqa.api.schema.CsvAwareSchema;
import de.gwdg.metadataqa.api.schema.Format;
import de.gwdg.metadataqa.api.schema.Schema;
import de.gwdg.metadataqa.api.schema.SchemaUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class BaseSchema
implements Schema,
CsvAwareSchema,
Serializable {
    private static final long serialVersionUID = 6775942932769040511L;
    private static final Logger LOGGER = Logger.getLogger(BaseSchema.class.getCanonicalName());
    private final Map<String, DataElement> paths = new LinkedHashMap<String, DataElement>();
    private final Map<String, DataElement> collectionPaths = new LinkedHashMap<String, DataElement>();
    private final Map<String, DataElement> directChildren = new LinkedHashMap<String, DataElement>();
    private Map<String, String> extractableFields = new LinkedHashMap<String, String>();
    private List<FieldGroup> fieldGroups = new ArrayList<FieldGroup>();
    private List<String> categories = null;
    private List<RuleChecker> ruleCheckers;
    private List<DataElement> indexFields;
    private DataElement recordId;
    private Format format;
    private Map<String, String> namespaces;

    public BaseSchema addField(DataElement dataElement) {
        dataElement.setSchema(this);
        this.paths.put(dataElement.getLabel(), dataElement);
        if (dataElement.getParent() == null) {
            this.directChildren.put(dataElement.getLabel(), dataElement);
        }
        if (dataElement.isCollection()) {
            this.collectionPaths.put(dataElement.getLabel(), dataElement);
        }
        if (dataElement.isExtractable()) {
            this.addExtractableField(dataElement.getLabel(), dataElement.getPath());
        }
        return this;
    }

    public BaseSchema addField(String fieldName) {
        this.addField(new DataElement(fieldName));
        return this;
    }

    public BaseSchema addFields(String ... fields2) {
        for (String fieldName : fields2) {
            this.addField(fieldName);
        }
        return this;
    }

    public BaseSchema setFormat(Format format) {
        this.format = format;
        return this;
    }

    @Override
    public Format getFormat() {
        return this.format;
    }

    @Override
    public List<DataElement> getCollectionPaths() {
        return new ArrayList<DataElement>(this.collectionPaths.values());
    }

    @Override
    public List<DataElement> getRootChildrenPaths() {
        return new ArrayList<DataElement>(this.directChildren.values());
    }

    @Override
    public List<DataElement> getPaths() {
        return new ArrayList<DataElement>(this.paths.values());
    }

    @Override
    public DataElement getPathByLabel(String label) {
        return this.paths.get(label);
    }

    public BaseSchema addFieldGroup(FieldGroup fieldgroup) {
        this.fieldGroups.add(fieldgroup);
        return this;
    }

    @Override
    public List<FieldGroup> getFieldGroups() {
        return this.fieldGroups;
    }

    @Override
    public List<String> getNoLanguageFields() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public List<DataElement> getIndexFields() {
        if (this.indexFields == null) {
            this.indexFields = new ArrayList<DataElement>();
            for (DataElement dataElement : this.getPaths()) {
                if (StringUtils.isNotBlank(dataElement.getIndexField())) {
                    this.indexFields.add(dataElement);
                    continue;
                }
                if (dataElement.getRules() == null) continue;
                for (Rule rule : dataElement.getRules()) {
                    if (rule.getUnique() == null || !rule.getUnique().equals(Boolean.TRUE)) continue;
                    LOGGER.warning(dataElement + " does not have index field");
                    this.indexFields.add(dataElement);
                }
            }
        }
        return this.indexFields;
    }

    @Override
    public Map<String, String> getExtractableFields() {
        return this.extractableFields;
    }

    @Override
    public void setExtractableFields(Map<String, String> extractableFields) {
        this.extractableFields = extractableFields;
    }

    @Override
    public void addExtractableField(String label, String path) {
        this.extractableFields.put(label, path);
    }

    @Override
    public List<String> getCategories() {
        if (this.categories == null) {
            this.categories = Category.extractCategories(this.paths.values());
        }
        return this.categories;
    }

    @Override
    public List<RuleChecker> getRuleCheckers() {
        if (this.ruleCheckers == null) {
            this.ruleCheckers = SchemaUtils.getRuleCheckers(this);
        }
        return this.ruleCheckers;
    }

    @Override
    public List<String> getHeader() {
        ArrayList<String> headers = new ArrayList<String>();
        for (DataElement dataElement : this.paths.values()) {
            headers.add(dataElement.getPath());
        }
        return headers;
    }

    public String toString() {
        return "BaseSchema{categories=" + this.categories + ", format=" + this.format + "}";
    }

    public void setCategories(List<String> categories) {
        this.categories = categories;
    }

    public void setNamespaces(Map<String, String> namespaces) {
        this.namespaces = namespaces;
    }

    @Override
    public Map<String, String> getNamespaces() {
        return this.namespaces;
    }

    @Override
    public DataElement getRecordId() {
        return this.recordId;
    }

    public void setRecordId(DataElement recordId) {
        this.recordId = recordId;
    }
}

