/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.api.rule.singlefieldchecker;

import de.gwdg.metadataqa.api.counter.FieldCounter;
import de.gwdg.metadataqa.api.json.DataElement;
import de.gwdg.metadataqa.api.model.XmlFieldInstance;
import de.gwdg.metadataqa.api.model.selector.Selector;
import de.gwdg.metadataqa.api.rule.RuleCheckerOutput;
import de.gwdg.metadataqa.api.rule.RuleCheckingOutputStatus;
import de.gwdg.metadataqa.api.rule.RuleCheckingOutputType;
import de.gwdg.metadataqa.api.rule.singlefieldchecker.SingleFieldChecker;
import java.util.List;

public class NumericValueChecker
extends SingleFieldChecker {
    private static final long serialVersionUID = 6281320551990118341L;
    protected double limit;
    protected TYPE type;

    public NumericValueChecker(DataElement field, int limit, TYPE type2) {
        this(field, (double)limit, type2);
    }

    public NumericValueChecker(DataElement field, double limit, TYPE type2) {
        super(field, field.getLabel() + ":" + type2.prefix);
        this.type = type2;
        this.limit = limit;
    }

    @Override
    public void update(Selector cache2, FieldCounter<RuleCheckerOutput> results, RuleCheckingOutputType outputType) {
        if (this.isDebug()) {
            LOGGER.info(this.getClass().getSimpleName() + " " + this.id);
        }
        boolean allPassed = true;
        boolean isNA = true;
        List instances = cache2.get(this.field.getPath());
        if (instances != null && !instances.isEmpty()) {
            for (XmlFieldInstance instance : instances) {
                if (!instance.hasValue()) continue;
                if (this.isDebug()) {
                    LOGGER.info("value: " + instance.getValue());
                }
                String stringValue = instance.getValue();
                isNA = false;
                try {
                    double value = Double.parseDouble(stringValue);
                    allPassed = this.checkValue(value);
                }
                catch (NumberFormatException e) {
                    allPassed = false;
                }
                if (allPassed) continue;
                break;
            }
        }
        this.addOutput(results, isNA, allPassed, outputType);
        if (this.isDebug()) {
            LOGGER.info(this.getClass().getSimpleName() + " " + this.id + ") result: " + RuleCheckingOutputStatus.create(isNA, allPassed));
        }
    }

    private boolean checkValue(double value) {
        boolean allPassed = true;
        switch (this.type) {
            case MIN_INCLUSIVE: {
                if (!(value < this.limit)) break;
                allPassed = false;
                break;
            }
            case MAX_INCLUSIVE: {
                if (!(value > this.limit)) break;
                allPassed = false;
                break;
            }
            case MIN_EXCLUSIVE: {
                if (!(value <= this.limit)) break;
                allPassed = false;
                break;
            }
            case MAX_EXCLUSIVE: {
                if (!(value >= this.limit)) break;
                allPassed = false;
                break;
            }
        }
        return allPassed;
    }

    public static enum TYPE {
        MIN_INCLUSIVE("minInclusive"),
        MAX_INCLUSIVE("maxInclusive"),
        MIN_EXCLUSIVE("minExclusive"),
        MAX_EXCLUSIVE("maxExclusive");

        private final String prefix;

        private TYPE(String prefix) {
            this.prefix = prefix;
        }
    }
}

