/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.api.rule.singlefieldchecker;

import de.gwdg.metadataqa.api.counter.FieldCounter;
import de.gwdg.metadataqa.api.json.DataElement;
import de.gwdg.metadataqa.api.model.XmlFieldInstance;
import de.gwdg.metadataqa.api.model.selector.Selector;
import de.gwdg.metadataqa.api.rule.RuleCheckerOutput;
import de.gwdg.metadataqa.api.rule.RuleCheckingOutputStatus;
import de.gwdg.metadataqa.api.rule.RuleCheckingOutputType;
import de.gwdg.metadataqa.api.rule.singlefieldchecker.SingleFieldChecker;
import java.util.List;

public class MaxLengthChecker
extends SingleFieldChecker {
    private static final long serialVersionUID = -3991731520985560338L;
    public static final String PREFIX = "maxLength";
    protected Integer maxLength;

    public MaxLengthChecker(DataElement field, Integer maxLength) {
        this(field, field.getLabel(), maxLength);
    }

    public MaxLengthChecker(DataElement field, String header, Integer maxLength) {
        super(field, header + ":maxLength");
        this.maxLength = maxLength;
    }

    @Override
    public void update(Selector cache2, FieldCounter<RuleCheckerOutput> results, RuleCheckingOutputType outputType) {
        if (this.isDebug()) {
            LOGGER.info(this.getClass().getSimpleName() + " " + this.id);
        }
        boolean allPassed = true;
        boolean isNA = true;
        List instances = cache2.get(this.field.getPath());
        if (instances != null && !instances.isEmpty()) {
            for (XmlFieldInstance instance : instances) {
                if (!instance.hasValue()) continue;
                isNA = false;
                if (this.isDebug()) {
                    LOGGER.info("value: " + instance.getValue());
                }
                if (instance.getValue().length() <= this.maxLength) continue;
                allPassed = false;
                break;
            }
        }
        this.addOutput(results, isNA, allPassed, outputType);
        if (this.isDebug()) {
            LOGGER.info(this.getClass().getSimpleName() + " " + this.id + ") result: " + RuleCheckingOutputStatus.create(isNA, allPassed));
        }
    }
}

