/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.api.rule.singlefieldchecker;

import de.gwdg.metadataqa.api.counter.FieldCounter;
import de.gwdg.metadataqa.api.json.DataElement;
import de.gwdg.metadataqa.api.model.selector.Selector;
import de.gwdg.metadataqa.api.rule.RuleCheckerOutput;
import de.gwdg.metadataqa.api.rule.RuleCheckingOutputStatus;
import de.gwdg.metadataqa.api.rule.RuleCheckingOutputType;
import de.gwdg.metadataqa.api.rule.singlefieldchecker.SingleFieldChecker;
import de.gwdg.metadataqa.api.util.InstanceCounter;

public class MaxCountChecker
extends SingleFieldChecker {
    private static final long serialVersionUID = 3259638493041988749L;
    public static final String PREFIX = "maxCount";
    private boolean allowEmptyInstances = false;
    protected Integer maxCount;

    public MaxCountChecker(DataElement field, int maxCount) {
        this(field, field.getLabel(), maxCount);
    }

    public MaxCountChecker(DataElement field, int maxCount, boolean allowEmptyInstances) {
        this(field, field.getLabel(), maxCount);
        this.allowEmptyInstances = allowEmptyInstances;
    }

    public MaxCountChecker(DataElement field, String header, int maxCount) {
        super(field, header + ":maxCount");
        this.maxCount = maxCount;
    }

    @Override
    public void update(Selector cache2, FieldCounter<RuleCheckerOutput> results, RuleCheckingOutputType outputType) {
        if (this.isDebug()) {
            LOGGER.info(this.getClass().getSimpleName() + " " + this.id);
        }
        boolean allPassed = false;
        InstanceCounter counter = new InstanceCounter(cache2, this.field, this.allowEmptyInstances);
        if (this.isDebug()) {
            LOGGER.info(this.getClass().getSimpleName() + " " + this.id + ") value: " + counter.getCount());
        }
        if (counter.getCount() <= this.maxCount) {
            allPassed = true;
        }
        if (counter.isNA() && this.maxCount == 0) {
            counter.ignoreNA();
        }
        this.addOutput(results, counter.isNA(), allPassed, outputType);
        if (this.isDebug()) {
            LOGGER.info(this.getClass().getSimpleName() + " " + this.id + ") result: " + RuleCheckingOutputStatus.create(counter.isNA(), allPassed));
        }
    }
}

