/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.api.rule.singlefieldchecker;

import de.gwdg.metadataqa.api.counter.FieldCounter;
import de.gwdg.metadataqa.api.json.DataElement;
import de.gwdg.metadataqa.api.model.XmlFieldInstance;
import de.gwdg.metadataqa.api.model.selector.Selector;
import de.gwdg.metadataqa.api.rule.RuleCheckerOutput;
import de.gwdg.metadataqa.api.rule.RuleCheckingOutputStatus;
import de.gwdg.metadataqa.api.rule.RuleCheckingOutputType;
import de.gwdg.metadataqa.api.rule.singlefieldchecker.SingleFieldChecker;
import de.gwdg.metadataqa.api.util.Dimension;
import de.gwdg.metadataqa.api.util.DimensionDao;
import de.gwdg.metadataqa.api.util.ImageDimensionExtractor;
import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;

public class ImageDimensionChecker
extends SingleFieldChecker {
    private static final Logger LOGGER = Logger.getLogger(ImageDimensionChecker.class.getCanonicalName());
    public static final String PREFIX = "imageDimension";
    protected Dimension dimensionRule;

    public ImageDimensionChecker(DataElement field, Dimension dimension) {
        this(field, field.getLabel(), dimension);
    }

    public ImageDimensionChecker(DataElement field, String header, Dimension dimension) {
        super(field, header + ":imageDimension");
        this.dimensionRule = dimension;
    }

    @Override
    public void update(Selector cache2, FieldCounter<RuleCheckerOutput> results, RuleCheckingOutputType outputType) {
        if (this.isDebug()) {
            LOGGER.info(this.getClass().getSimpleName() + " " + this.id);
        }
        boolean allPassed = true;
        boolean isNA = true;
        List instances = cache2.get(this.field.getPath());
        if (instances != null && !instances.isEmpty()) {
            for (XmlFieldInstance instance : instances) {
                if (!instance.hasValue()) continue;
                isNA = false;
                try {
                    DimensionDao dimension;
                    if (this.isDebug()) {
                        LOGGER.info("value: " + instance.getValue());
                    }
                    if ((dimension = ImageDimensionExtractor.extractRemote(instance.getValue())) == null || this.dimensionRule.getMinWidth() != null && dimension.getWidth() < this.dimensionRule.getMinWidth() || this.dimensionRule.getMaxWidth() != null && dimension.getWidth() > this.dimensionRule.getMaxWidth() || this.dimensionRule.getMinHeight() != null && dimension.getHeight() < this.dimensionRule.getMinHeight() || this.dimensionRule.getMaxHeight() != null && dimension.getHeight() > this.dimensionRule.getMaxHeight() || this.dimensionRule.getMinShortside() != null && dimension.getShort() < this.dimensionRule.getMinShortside() || this.dimensionRule.getMaxShortside() != null && dimension.getShort() > this.dimensionRule.getMaxShortside() || this.dimensionRule.getMinLongside() != null && dimension.getLong() < this.dimensionRule.getMinLongside() || this.dimensionRule.getMaxLongside() != null && dimension.getLong() > this.dimensionRule.getMaxLongside()) {
                        allPassed = false;
                    }
                }
                catch (IOException e) {
                    allPassed = false;
                }
                if (allPassed) continue;
                break;
            }
        }
        this.addOutput(results, isNA, allPassed, outputType);
        if (this.isDebug()) {
            LOGGER.info(this.getClass().getSimpleName() + " " + this.id + ") result: " + RuleCheckingOutputStatus.create(isNA, allPassed));
        }
    }
}

