/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.api.rule.singlefieldchecker;

import de.gwdg.metadataqa.api.counter.FieldCounter;
import de.gwdg.metadataqa.api.json.DataElement;
import de.gwdg.metadataqa.api.model.XmlFieldInstance;
import de.gwdg.metadataqa.api.model.selector.Selector;
import de.gwdg.metadataqa.api.rule.RuleCheckerOutput;
import de.gwdg.metadataqa.api.rule.RuleCheckingOutputStatus;
import de.gwdg.metadataqa.api.rule.RuleCheckingOutputType;
import de.gwdg.metadataqa.api.rule.singlefieldchecker.SingleFieldChecker;
import java.util.List;

public class EnumerationChecker
extends SingleFieldChecker {
    private static final long serialVersionUID = 5185953247558241405L;
    public static final String PREFIX = "in";
    protected List<String> fixedValues;

    public EnumerationChecker(DataElement field, List<String> fixedValues) {
        this(field, field.getLabel(), fixedValues);
    }

    public EnumerationChecker(DataElement field, String header, List<String> fixedValues) {
        super(field, header + ":in");
        this.fixedValues = fixedValues;
    }

    @Override
    public void update(Selector cache2, FieldCounter<RuleCheckerOutput> results, RuleCheckingOutputType outputType) {
        if (this.isDebug()) {
            LOGGER.info(this.getClass().getSimpleName() + " " + this.id);
        }
        boolean allPassed = true;
        boolean isNA = true;
        List instances = cache2.get(this.field.getPath());
        if (instances != null && !instances.isEmpty()) {
            for (XmlFieldInstance instance : instances) {
                if (!instance.hasValue()) continue;
                isNA = false;
                if (this.isDebug()) {
                    LOGGER.info("value: " + instance.getValue());
                }
                if (this.fixedValues.contains(instance.getValue())) continue;
                allPassed = false;
                break;
            }
        }
        this.addOutput(results, isNA, allPassed, outputType);
        if (this.isDebug()) {
            LOGGER.info(this.getClass().getSimpleName() + " " + this.id + ") result: " + RuleCheckingOutputStatus.create(isNA, allPassed));
        }
    }
}

