/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.api.rule.pairchecker;

import de.gwdg.metadataqa.api.counter.FieldCounter;
import de.gwdg.metadataqa.api.json.DataElement;
import de.gwdg.metadataqa.api.model.XmlFieldInstance;
import de.gwdg.metadataqa.api.model.selector.Selector;
import de.gwdg.metadataqa.api.rule.RuleCheckerOutput;
import de.gwdg.metadataqa.api.rule.RuleCheckingOutputStatus;
import de.gwdg.metadataqa.api.rule.RuleCheckingOutputType;
import de.gwdg.metadataqa.api.rule.pairchecker.PropertyPairChecker;
import java.util.List;

public class DisjointChecker
extends PropertyPairChecker {
    private static final long serialVersionUID = -2921501305139849002L;
    public static final String PREFIX = "disjoint";

    public DisjointChecker(DataElement field1, DataElement field2) {
        super(field1, field2, PREFIX);
    }

    @Override
    public void update(Selector cache2, FieldCounter<RuleCheckerOutput> results, RuleCheckingOutputType outputType) {
        if (this.isDebug()) {
            LOGGER.info(this.getClass().getSimpleName() + " " + this.id);
        }
        boolean allPassed = true;
        boolean isNA = false;
        List instances1 = cache2.get(this.field1.getAbsolutePath().replace("[*]", ""));
        List instances2 = cache2.get(this.field2.getAbsolutePath().replace("[*]", ""));
        if (instances1 != null && !instances1.isEmpty() && instances2 != null && !instances2.isEmpty()) {
            block0: for (XmlFieldInstance instance1 : instances1) {
                if (!instance1.hasValue()) continue;
                for (XmlFieldInstance instance2 : instances2) {
                    if (this.isDebug()) {
                        LOGGER.info(String.format("%s %s values: '%s' vs '%s'", this.getClass().getSimpleName(), this.id, instance1.getValue(), instance2.getValue()));
                    }
                    if (!instance2.hasValue() || !instance1.getValue().equals(instance2.getValue())) continue;
                    allPassed = false;
                    continue block0;
                }
            }
        }
        this.addOutput(results, isNA, allPassed, outputType);
        if (this.isDebug()) {
            LOGGER.info(this.getClass().getSimpleName() + " " + this.id + ") result: " + RuleCheckingOutputStatus.create(isNA, allPassed));
        }
    }
}

