/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.api.rule;

import de.gwdg.metadataqa.api.counter.FieldCounter;
import de.gwdg.metadataqa.api.interfaces.Calculator;
import de.gwdg.metadataqa.api.interfaces.MetricResult;
import de.gwdg.metadataqa.api.model.selector.Selector;
import de.gwdg.metadataqa.api.problemcatalog.FieldCounterBasedResult;
import de.gwdg.metadataqa.api.rule.RuleChecker;
import de.gwdg.metadataqa.api.rule.RuleCheckerOutput;
import de.gwdg.metadataqa.api.rule.RuleCheckingOutputStatus;
import de.gwdg.metadataqa.api.rule.RuleCheckingOutputType;
import de.gwdg.metadataqa.api.schema.Schema;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class RuleCatalog
implements Calculator,
Serializable {
    private static final String CALCULATOR_NAME = "ruleCatalog";
    private Schema schema;
    private boolean onlyIdInHeader = false;
    private RuleCheckingOutputType outputType = RuleCheckingOutputType.BOTH;
    private boolean hiddenIdsCollected = false;
    private List<String> hiddenIds = new ArrayList<String>();

    public RuleCatalog(Schema schema) {
        this.schema = schema;
    }

    @Override
    public List<MetricResult> measure(Selector cache2) {
        FieldCounter<RuleCheckerOutput> fieldCounter = new FieldCounter<RuleCheckerOutput>();
        int totalScore = 0;
        for (RuleChecker ruleChecker : this.schema.getRuleCheckers()) {
            String key;
            Integer score;
            ruleChecker.update(cache2, fieldCounter, this.outputType);
            if (this.outputType != RuleCheckingOutputType.STATUS && !ruleChecker.isHidden() && (score = fieldCounter.get(key = this.outputType.equals((Object)RuleCheckingOutputType.BOTH) ? ruleChecker.getHeader(RuleCheckingOutputType.SCORE) : ruleChecker.getHeader()).getScore()) != null) {
                totalScore += score.intValue();
            }
            if (this.hiddenIdsCollected) continue;
            this.collectHiddenIds(this.hiddenIds, ruleChecker);
        }
        if (!this.hiddenIdsCollected) {
            this.hiddenIdsCollected = true;
        }
        if (this.outputType != RuleCheckingOutputType.STATUS) {
            fieldCounter.put("ruleCatalog:score", new RuleCheckerOutput(RuleCheckingOutputStatus.NA, totalScore).setOutputType(this.outputType));
        }
        this.removeHiddenScores(fieldCounter, this.hiddenIds);
        return List.of(new FieldCounterBasedResult<RuleCheckerOutput>(this.getCalculatorName(), fieldCounter));
    }

    @Override
    public List<String> getHeader() {
        ArrayList<String> headers = new ArrayList<String>();
        for (RuleChecker ruleChecker : this.schema.getRuleCheckers()) {
            if (ruleChecker.isHidden()) continue;
            if (this.outputType != RuleCheckingOutputType.BOTH) {
                headers.add(this.onlyIdInHeader ? ruleChecker.getId() : ruleChecker.getHeader());
                continue;
            }
            headers.add((String)(this.onlyIdInHeader ? ruleChecker.getId() + ":status" : ruleChecker.getHeader(RuleCheckingOutputType.STATUS)));
            headers.add((String)(this.onlyIdInHeader ? ruleChecker.getId() + ":score" : ruleChecker.getHeader(RuleCheckingOutputType.SCORE)));
        }
        if (this.outputType != RuleCheckingOutputType.STATUS) {
            headers.add("ruleCatalog:score");
        }
        return headers;
    }

    @Override
    public String getCalculatorName() {
        return CALCULATOR_NAME;
    }

    public RuleCatalog setOnlyIdInHeader(boolean onlyIdInHeader) {
        this.onlyIdInHeader = onlyIdInHeader;
        return this;
    }

    public RuleCatalog setOutputType(RuleCheckingOutputType outputType) {
        this.outputType = outputType;
        return this;
    }

    private void collectHiddenIds(List<String> hiddenIds, RuleChecker ruleChecker) {
        if (ruleChecker.isHidden()) {
            if (this.outputType.equals((Object)RuleCheckingOutputType.BOTH)) {
                hiddenIds.add(ruleChecker.getHeader(RuleCheckingOutputType.SCORE));
                hiddenIds.add(ruleChecker.getHeader(RuleCheckingOutputType.STATUS));
            } else {
                hiddenIds.add(ruleChecker.getHeader());
            }
        }
    }

    private void removeHiddenScores(FieldCounter<RuleCheckerOutput> fieldCounter, List<String> hiddenIds) {
        if (!hiddenIds.isEmpty()) {
            for (String hiddenId : hiddenIds) {
                fieldCounter.remove(hiddenId);
            }
        }
    }
}

