/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.api.rule;

import de.gwdg.metadataqa.api.counter.FieldCounter;
import de.gwdg.metadataqa.api.rule.RuleChecker;
import de.gwdg.metadataqa.api.rule.RuleCheckerOutput;
import de.gwdg.metadataqa.api.rule.RuleCheckingOutputType;
import java.util.logging.Logger;

public abstract class BaseRuleChecker
implements RuleChecker {
    protected static final Logger LOGGER = Logger.getLogger(BaseRuleChecker.class.getCanonicalName());
    protected String id;
    protected Integer failureScore;
    protected Integer successScore;
    protected String header;
    protected Boolean hidden = false;
    private Boolean debug = false;

    @Override
    public String getId() {
        return this.id == null ? String.valueOf(0) : this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public Integer getFailureScore() {
        return this.failureScore;
    }

    @Override
    public void setFailureScore(Integer failureScore) {
        this.failureScore = failureScore;
    }

    @Override
    public Integer getSuccessScore() {
        return this.successScore;
    }

    @Override
    public void setSuccessScore(Integer successScore) {
        this.successScore = successScore;
    }

    @Override
    public String getHeaderWithoutId() {
        return this.header;
    }

    @Override
    public String getHeader() {
        return this.header + ":" + this.getId();
    }

    @Override
    public String getHeader(RuleCheckingOutputType outputType) {
        String suffix = "";
        if (outputType.equals((Object)RuleCheckingOutputType.STATUS)) {
            suffix = ":status";
        } else if (outputType.equals((Object)RuleCheckingOutputType.SCORE)) {
            suffix = ":score";
        }
        return this.header + ":" + this.getId() + suffix;
    }

    protected void addOutput(FieldCounter<RuleCheckerOutput> results, boolean isNA, boolean allPassed, RuleCheckingOutputType outputType) {
        if (outputType.equals((Object)RuleCheckingOutputType.STATUS) || outputType.equals((Object)RuleCheckingOutputType.SCORE)) {
            results.put(this.getHeader(), new RuleCheckerOutput(this, isNA, allPassed).setOutputType(outputType));
        } else {
            results.put(this.getHeader(RuleCheckingOutputType.STATUS), new RuleCheckerOutput(this, isNA, allPassed).setOutputType(RuleCheckingOutputType.STATUS));
            results.put(this.getHeader(RuleCheckingOutputType.SCORE), new RuleCheckerOutput(this, isNA, allPassed).setOutputType(RuleCheckingOutputType.SCORE));
        }
    }

    @Override
    public void setHidden() {
        this.hidden = true;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public void setDebug() {
        this.debug = true;
    }

    public boolean isDebug() {
        return this.debug;
    }
}

