/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.api.problemcatalog.skos;

import de.gwdg.metadataqa.api.counter.FieldCounter;
import de.gwdg.metadataqa.api.json.DataElement;
import de.gwdg.metadataqa.api.model.EdmFieldInstance;
import de.gwdg.metadataqa.api.model.selector.Selector;
import de.gwdg.metadataqa.api.problemcatalog.ProblemCatalog;
import de.gwdg.metadataqa.api.problemcatalog.ProblemDetector;
import de.gwdg.metadataqa.api.schema.Schema;
import de.gwdg.metadataqa.api.util.Converter;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AmbiguousPrefLabel
extends ProblemDetector
implements Serializable {
    private static final String NAME = "AmbiguousPrefLabel";
    private static final List<String> LABELS = Arrays.asList("Agent/skos:prefLabel", "Concept/skos:prefLabel", "Place/skos:prefLabel", "Timespan/skos:prefLabel");
    private static final long serialVersionUID = 7644339329704804931L;

    public AmbiguousPrefLabel(ProblemCatalog problemCatalog) {
        this.problemCatalog = problemCatalog;
        this.problemCatalog.addObserver(this);
        this.schema = problemCatalog.getSchema();
    }

    @Override
    public void update(Selector cache2, FieldCounter<Double> results) {
        int value = 0;
        for (String label : LABELS) {
            DataElement dataElement = ((Schema)((Object)this.schema)).getPathByLabel(label);
            String parentPath = dataElement.getParent().getPath();
            Object rawEntityFragment = cache2.getFragment(parentPath);
            if (rawEntityFragment == null) continue;
            List<Object> entities = Converter.jsonObjectToList(rawEntityFragment, (Schema)((Object)this.schema));
            for (int i = 0; i < entities.size(); ++i) {
                value += this.countPerEntity(i, dataElement, cache2);
            }
        }
        results.put(NAME, Double.valueOf(value));
    }

    private int countPerEntity(int entityCounter, DataElement dataElement, Selector cache2) {
        List<EdmFieldInstance> subjects = cache2.get(dataElement.getAbsolutePath(entityCounter));
        Map<String, Integer> labelCounter = this.countLabelsPerFields(subjects);
        return this.countAmbiguousPrefLabels(labelCounter);
    }

    private Map<String, Integer> countLabelsPerFields(List<EdmFieldInstance> subjects) {
        HashMap<String, Integer> labelCounter = new HashMap<String, Integer>();
        for (EdmFieldInstance subject : subjects) {
            if (subject.getLanguage() == null) continue;
            labelCounter.computeIfAbsent(subject.getLanguage(), s -> 0);
            labelCounter.put(subject.getLanguage(), (Integer)labelCounter.get(subject.getLanguage()) + 1);
        }
        return labelCounter;
    }

    private int countAmbiguousPrefLabels(Map<String, Integer> labelCounter) {
        int value = 0;
        for (Map.Entry<String, Integer> entry : labelCounter.entrySet()) {
            if (entry.getValue() <= 1) continue;
            ++value;
        }
        return value;
    }

    @Override
    public String getHeader() {
        return NAME;
    }
}

