/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.api.problemcatalog;

import de.gwdg.metadataqa.api.counter.FieldCounter;
import de.gwdg.metadataqa.api.model.EdmFieldInstance;
import de.gwdg.metadataqa.api.model.selector.Selector;
import de.gwdg.metadataqa.api.problemcatalog.ProblemCatalog;
import de.gwdg.metadataqa.api.problemcatalog.ProblemDetector;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class LongSubject
extends ProblemDetector
implements Serializable {
    private static final String NAME = "LongSubject";
    private static final int MAX_LENGTH = 50;
    private static final long serialVersionUID = 4666546113157987333L;

    public LongSubject(ProblemCatalog problemCatalog) {
        this.problemCatalog = problemCatalog;
        this.problemCatalog.addObserver(this);
        this.schema = problemCatalog.getSchema();
    }

    @Override
    public void update(Selector cache2, FieldCounter<Double> results) {
        double value = 0.0;
        List subjects = cache2.get(this.schema.getSubjectPath());
        if (subjects != null && !subjects.isEmpty()) {
            for (EdmFieldInstance subject : subjects) {
                if (!StringUtils.isNotBlank(subject.getValue()) || subject.getValue().length() <= 50) continue;
                value += 1.0;
            }
        }
        results.put(NAME, value);
    }

    @Override
    public String getHeader() {
        return NAME;
    }
}

