/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.api.problemcatalog;

import de.gwdg.metadataqa.api.counter.FieldCounter;
import de.gwdg.metadataqa.api.interfaces.MetricResult;
import de.gwdg.metadataqa.api.util.CompressionLevel;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class FieldCounterBasedResult<T>
implements MetricResult {
    protected String name;
    protected FieldCounter<T> fieldCounter;
    protected boolean noCompression = false;

    public FieldCounterBasedResult(String name, FieldCounter<T> fieldCounter) {
        this.name = name;
        this.fieldCounter = fieldCounter;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Map<String, ? extends Object> getResultMap() {
        return this.fieldCounter.getMap();
    }

    @Override
    public Map<String, Map<String, ? extends Object>> getLabelledResultMap() {
        LinkedHashMap<String, Map<String, ? extends Object>> labelledResultMap = new LinkedHashMap<String, Map<String, ? extends Object>>();
        labelledResultMap.put(this.name, this.fieldCounter.getMap());
        return labelledResultMap;
    }

    @Override
    public String getCsv(boolean withLabels, CompressionLevel compressionLevel) {
        return this.fieldCounter.getCsv(withLabels, this.overrideCompressionLevel(compressionLevel));
    }

    @Override
    public List<Object> getCsv() {
        return this.fieldCounter.getCsv();
    }

    @Override
    public List<String> getList(boolean withLabels, CompressionLevel compressionLevel) {
        return this.fieldCounter.getList(withLabels, this.overrideCompressionLevel(compressionLevel));
    }

    private CompressionLevel overrideCompressionLevel(CompressionLevel compressionLevel) {
        return this.noCompression ? CompressionLevel.ZERO : compressionLevel;
    }

    public MetricResult withNoCompression() {
        this.noCompression = true;
        return this;
    }

    public String toString() {
        return "FieldCounterBasedResult{name='" + this.name + "', fieldCounter=" + this.fieldCounter + ", noCompression=" + this.noCompression + "}";
    }
}

