/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.api.problemcatalog;

import de.gwdg.metadataqa.api.counter.FieldCounter;
import de.gwdg.metadataqa.api.model.EdmFieldInstance;
import de.gwdg.metadataqa.api.model.selector.Selector;
import de.gwdg.metadataqa.api.problemcatalog.ProblemCatalog;
import de.gwdg.metadataqa.api.problemcatalog.ProblemDetector;
import de.gwdg.metadataqa.api.util.StringDuplicationDetector;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class DuplicatedStrings
extends ProblemDetector
implements Serializable {
    private static final String NAME = "DuplicatedStrings";
    private static final long serialVersionUID = -4765488439405459205L;

    public DuplicatedStrings(ProblemCatalog problemCatalog) {
        this.problemCatalog = problemCatalog;
        this.problemCatalog.addObserver(this);
        this.schema = problemCatalog.getSchema();
    }

    @Override
    public void update(Selector cache2, FieldCounter<Double> results) {
        double value = 0.0;
        for (String path : this.schema.getEmptyStringPaths()) {
            List subjects = cache2.get(path);
            if (subjects == null || subjects.isEmpty()) continue;
            for (EdmFieldInstance subject : subjects) {
                if (!StringUtils.isNotBlank(subject.getValue()) || !StringDuplicationDetector.isDuplicated(subject.getValue())) continue;
                value += 1.0;
            }
        }
        results.put(NAME, value);
    }

    @Override
    public String getHeader() {
        return NAME;
    }
}

