/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.api.model.selector;

import com.jayway.jsonpath.InvalidJsonException;
import de.gwdg.metadataqa.api.model.XmlFieldInstance;
import de.gwdg.metadataqa.api.model.selector.BaseSelector;
import de.gwdg.metadataqa.api.util.CsvReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class CsvSelector<T extends XmlFieldInstance>
extends BaseSelector<T> {
    private static final Logger LOGGER = Logger.getLogger(CsvSelector.class.getCanonicalName());
    private static final long serialVersionUID = -545628995288633641L;
    private Map<String, String> record;

    public CsvSelector(String content) throws InvalidJsonException {
        this.content = content;
    }

    public CsvSelector(Object jsonDocument) {
    }

    public CsvSelector(CsvReader csvReader, List<String> input) {
        this.record = csvReader.createMap(input);
    }

    @Override
    protected void set(String address, String path, Object jsonFragment, Class clazz) {
        Object instances = this.read(path, jsonFragment);
        this.cache.put(address, instances);
    }

    @Override
    public List<T> read(String path, Object jsonFragment) {
        List<XmlFieldInstance> list = null;
        if (this.record.containsKey(path) && StringUtils.isNotBlank(this.record.get(path))) {
            list = Arrays.asList(new XmlFieldInstance(this.record.get(path)));
        }
        return list;
    }

    @Override
    public Object getFragment(String path) {
        return this.content;
    }

    @Override
    public Object getFragment(String address, String path, Object jsonFragment) {
        return this.content;
    }

    public void setCsvReader(CsvReader csvReader) {
        try {
            this.record = csvReader.asMap(this.content);
        }
        catch (IOException e) {
            LOGGER.warning(e.getLocalizedMessage());
        }
    }
}

