/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.api.model;

import de.gwdg.metadataqa.api.model.XmlFieldInstance;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class EdmFieldInstance
extends XmlFieldInstance {
    private String resource;

    public EdmFieldInstance() {
    }

    public EdmFieldInstance(String value) {
        super(value);
    }

    public EdmFieldInstance(String value, String language) {
        super(value, language);
    }

    public EdmFieldInstance(String value, String language, String resource) {
        super(value, language);
        this.resource = resource;
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public boolean hasResource() {
        return StringUtils.isNotBlank(this.resource);
    }

    @Override
    public boolean isEmpty() {
        return !this.hasValue() && !this.hasLanguage() && !this.hasResource();
    }

    public boolean isUrl() {
        return this.hasResource() || this.hasValue() && (this.getValue().startsWith("http://") || this.getValue().startsWith("https://"));
    }

    public String getUrl() {
        if (this.hasResource()) {
            return this.getResource();
        }
        if (this.isUrl()) {
            return this.getValue();
        }
        return null;
    }

    @Override
    public String toString() {
        return "EdmFieldInstance{value=" + this.getValue() + ", language=" + this.getLanguage() + ", resource=" + this.resource + "}";
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 19 * hash + Objects.hashCode(this.getValue());
        hash = 19 * hash + Objects.hashCode(this.getLanguage());
        hash = 19 * hash + Objects.hashCode(this.getResource());
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof EdmFieldInstance)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        EdmFieldInstance other = (EdmFieldInstance)obj;
        return Objects.equals(this.getValue(), other.getValue()) && Objects.equals(this.getLanguage(), other.getLanguage()) && Objects.equals(this.getResource(), other.getResource());
    }
}

