/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.api.model;

import de.gwdg.metadataqa.api.json.DataElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public enum Category {
    MANDATORY("mandatory"),
    DESCRIPTIVENESS("descriptiveness"),
    SEARCHABILITY("searchability"),
    CONTEXTUALIZATION("contextualization"),
    IDENTIFICATION("identification"),
    BROWSING("browsing"),
    VIEWING("viewing"),
    REUSABILITY("re-usability"),
    MULTILINGUALITY("multilinguality");

    private final String name;

    private Category(String name) {
        this.name = name;
    }

    public static List<String> extractCategories(Collection<DataElement> paths) {
        return Category.extractCategories(paths, false);
    }

    public static List<String> extractCategories(Collection<DataElement> paths, boolean reorder) {
        List<String> existingCategories = Category.extractExistingCategories(paths);
        if (reorder) {
            existingCategories = Category.reorder(existingCategories);
        }
        return existingCategories;
    }

    private static List<String> extractExistingCategories(Collection<DataElement> dataElements) {
        ArrayList<String> existingCategories = new ArrayList<String>();
        for (DataElement dataElement : dataElements) {
            if (!dataElement.isActive()) continue;
            for (String category : dataElement.getCategories()) {
                if (existingCategories.contains(category)) continue;
                existingCategories.add(category);
            }
        }
        return existingCategories;
    }

    private static List<String> reorder(List<String> existingCategories) {
        ArrayList<String> goodOrder = new ArrayList<String>();
        for (Category category : Category.values()) {
            if (!existingCategories.contains(category.toString())) continue;
            goodOrder.add(category.toString());
            existingCategories.remove(category.toString());
        }
        goodOrder.addAll(existingCategories);
        return goodOrder;
    }
}

